/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity.core.components;

import com.magmaguy.freeminecraftmodels.animation.AnimationManager;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.dataconverter.FileModelConverter;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import com.magmaguy.freeminecraftmodels.magmacore.util.MathToolkit;

public class AnimationComponent {
    private final ModeledEntity modeledEntity;
    private final int scaleDurationTicks = 20;
    private AnimationManager animationManager = null;
    private boolean isScalingDown = false;
    private int scaleTicksElapsed = 0;
    private double scaleStart = 1.0;
    private double scaleEnd = 0.0;

    public AnimationComponent(ModeledEntity modeledEntity) {
        this.modeledEntity = modeledEntity;
    }

    public void stopCurrentAnimations() {
        if (this.animationManager != null) {
            this.animationManager.stop();
        }
    }

    public boolean playAnimation(String animationName, boolean blendAnimation, boolean loop) {
        return this.animationManager.play(animationName, blendAnimation, loop);
    }

    public boolean hasAnimation(String animationName) {
        if (this.animationManager == null) {
            return false;
        }
        return this.animationManager.hasAnimation(animationName);
    }

    public boolean playDeathAnimation() {
        if (this.animationManager == null) {
            return false;
        }
        return this.animationManager.play("death", false, false);
    }

    public void tick() {
        if (this.isScalingDown) {
            ++this.scaleTicksElapsed;
            double t = Math.min((double)this.scaleTicksElapsed / 20.0, 1.0);
            this.modeledEntity.setScaleModifier(MathToolkit.lerp((float)this.scaleStart, (float)this.scaleEnd, (float)t));
            if (this.scaleTicksElapsed >= 20) {
                this.modeledEntity.setScaleModifier(0.0);
                this.isScalingDown = false;
                this.modeledEntity.remove();
            }
        }
        if (this.animationManager == null) {
            return;
        }
        this.animationManager.tick();
    }

    public void initializeAnimationManager(FileModelConverter fileModelConverter) {
        if (fileModelConverter.getAnimationsBlueprint() != null) {
            try {
                this.animationManager = new AnimationManager(this.modeledEntity, fileModelConverter.getAnimationsBlueprint());
            }
            catch (Exception e) {
                Logger.warn("Failed to initialize AnimationManager for entityID: " + this.modeledEntity.getEntityID() + ". Error: " + e.getMessage());
            }
        }
    }

    public void removeWithMinimizedAnimation() {
        this.isScalingDown = true;
        this.scaleTicksElapsed = 0;
        this.scaleStart = this.modeledEntity.getScaleModifier();
        this.scaleEnd = 0.0;
    }

    public void setAnimationManager(AnimationManager animationManager) {
        this.animationManager = animationManager;
    }

    public boolean isScalingDown() {
        return this.isScalingDown;
    }
}

