/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.dataconverter;

import com.google.gson.Gson;
import com.magmaguy.freeminecraftmodels.dataconverter.AnimationsBlueprint;
import com.magmaguy.freeminecraftmodels.dataconverter.ParsedTexture;
import com.magmaguy.freeminecraftmodels.dataconverter.SkeletonBlueprint;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import com.magmaguy.freeminecraftmodels.utils.StringToResourcePackFilename;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;

public class FileModelConverter {
    private static final HashMap<String, FileModelConverter> convertedFileModels = new HashMap();
    private final HashMap<String, Object> values = new HashMap();
    private final HashMap<String, Object> outliner = new HashMap();
    private String modelName;
    private SkeletonBlueprint skeletonBlueprint;
    private AnimationsBlueprint animationsBlueprint = null;
    private String ID;

    public FileModelConverter(File file) {
        BufferedReader reader;
        if (file.getName().contains(".bbmodel")) {
            this.modelName = file.getName().replace(".bbmodel", "");
        } else if (file.getName().contains(".fmmodel")) {
            this.modelName = file.getName().replace(".fmmodel", "");
        } else {
            Bukkit.getLogger().warning("File " + file.getName() + " should not be in the models folder!");
            return;
        }
        this.modelName = StringToResourcePackFilename.convert(this.modelName);
        Gson gson = new Gson();
        try {
            reader = Files.newBufferedReader(Paths.get(file.getPath(), new String[0]));
        }
        catch (Exception ex) {
            Logger.warn("Failed to read file " + file.getAbsolutePath());
            return;
        }
        Map map = gson.fromJson((Reader)reader, Map.class);
        try {
            ((Reader)reader).close();
        }
        catch (Exception exception) {
            Logger.warn("Failed to close reader for file!");
            return;
        }
        List<ParsedTexture> parsedTextures = this.parseTextures(map);
        ArrayList elementValues = (ArrayList)map.get("elements");
        for (Map element : elementValues) {
            this.values.put((String)element.get("uuid"), element);
        }
        ArrayList outlinerValues = (ArrayList)map.get("outliner");
        for (int i = 0; i < outlinerValues.size(); ++i) {
            Object e = outlinerValues.get(i);
            if (!(e instanceof Map)) continue;
            Map element = (Map)e;
            this.outliner.put((String)element.get("uuid"), element);
        }
        this.ID = this.modelName;
        this.skeletonBlueprint = new SkeletonBlueprint(parsedTextures, outlinerValues, this.values, this.generateFileTextures(parsedTextures), this.modelName, null);
        ArrayList animationList = (ArrayList)map.get("animations");
        if (animationList != null) {
            this.animationsBlueprint = new AnimationsBlueprint(animationList, this.modelName, this.skeletonBlueprint);
        }
        convertedFileModels.put(this.modelName, this);
    }

    public static void shutdown() {
        convertedFileModels.clear();
    }

    private List<ParsedTexture> parseTextures(Map<?, ?> map) {
        ArrayList<ParsedTexture> parsedTextures = new ArrayList<ParsedTexture>();
        ArrayList texturesValues = (ArrayList)map.get("textures");
        for (int i = 0; i < texturesValues.size(); ++i) {
            ParsedTexture parsedTexture = new ParsedTexture((Map)texturesValues.get(i), this.modelName, i);
            if (!parsedTexture.isValid()) continue;
            parsedTextures.add(new ParsedTexture((Map)texturesValues.get(i), this.modelName, i));
        }
        return parsedTextures;
    }

    private Map<String, Map<String, Object>> generateFileTextures(List<ParsedTexture> parsedTextures) {
        HashMap<String, Map<String, Object>> texturesMap = new HashMap<String, Map<String, Object>>();
        HashMap<CallSite, CallSite> textureContents = new HashMap<CallSite, CallSite>();
        for (ParsedTexture parsedTexture : parsedTextures) {
            textureContents.put((CallSite)((Object)("" + parsedTexture.getId())), (CallSite)((Object)("freeminecraftmodels:entity/" + this.modelName + "/" + parsedTexture.getFilename().replace(".png", ""))));
        }
        texturesMap.put("textures", textureContents);
        return texturesMap;
    }

    public static HashMap<String, FileModelConverter> getConvertedFileModels() {
        return convertedFileModels;
    }

    public SkeletonBlueprint getSkeletonBlueprint() {
        return this.skeletonBlueprint;
    }

    public AnimationsBlueprint getAnimationsBlueprint() {
        return this.animationsBlueprint;
    }

    public String getID() {
        return this.ID;
    }
}

