/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.dataconverter;

import com.magmaguy.freeminecraftmodels.dataconverter.BoneBlueprint;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import com.magmaguy.freeminecraftmodels.magmacore.util.Round;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.util.Vector;

public class HitboxBlueprint {
    private final String modelName;
    private Vector modelOffset = new Vector();
    private BoneBlueprint parent = null;
    private double widthX;
    private double widthZ;
    private double height;

    public HitboxBlueprint(Map<String, Object> boneJSON, HashMap<String, Object> values, String modelName, BoneBlueprint parent) {
        this.parent = parent;
        this.modelName = modelName;
        ArrayList childrenValues = (ArrayList)boneJSON.get("children");
        if (childrenValues.size() > 1) {
            Logger.warn("Model " + modelName + " has more than one value defining a hitbox! Only the first cube will be used to define the hitbox.");
        }
        if (childrenValues.isEmpty()) {
            Logger.warn("Model " + modelName + " has a hitbox bone but no hitbox cube! This means the hitbox won't be able to generate correctly!");
            return;
        }
        if (childrenValues.get(0) instanceof String) {
            this.parseCube((Map)values.get(childrenValues.get(0)));
        } else {
            Logger.warn("Model " + modelName + " has an invalid hitbox! The hitbox bone should only have one cube in it defining its boundaries.");
        }
    }

    public Vector getModelOffset() {
        return this.modelOffset.clone();
    }

    private void parseCube(Map<String, Object> cubeJSON) {
        double scaleFactor = 0.064;
        ArrayList fromList = (ArrayList)cubeJSON.get("from");
        Vector from = new Vector(Round.fourDecimalPlaces((Double)fromList.get(0) * scaleFactor), Round.fourDecimalPlaces((Double)fromList.get(1) * scaleFactor), Round.fourDecimalPlaces((Double)fromList.get(2) * scaleFactor));
        ArrayList toList = (ArrayList)cubeJSON.get("to");
        Vector to = new Vector(Round.fourDecimalPlaces((Double)toList.get(0) * scaleFactor), Round.fourDecimalPlaces((Double)toList.get(1) * scaleFactor), Round.fourDecimalPlaces((Double)toList.get(2) * scaleFactor));
        this.widthX = Math.abs(to.getX() - from.getX());
        this.widthZ = Math.abs(to.getZ() - from.getZ());
        this.height = Math.abs(from.getY() - to.getY());
        this.modelOffset = new Vector(0, 0, 0);
    }

    public double getWidthX() {
        return this.widthX;
    }

    public double getWidthZ() {
        return this.widthZ;
    }

    public double getHeight() {
        return this.height;
    }
}

