/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.listeners;

import com.magmaguy.freeminecraftmodels.MetadataHandler;
import com.magmaguy.freeminecraftmodels.customentity.PropEntity;
import com.magmaguy.freeminecraftmodels.dataconverter.FileModelConverter;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class ModelItemListener
implements Listener {
    private static final NamespacedKey MODEL_ID_KEY = new NamespacedKey(MetadataHandler.PLUGIN, "model_id");

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (!item.hasItemMeta() || !item.getItemMeta().getPersistentDataContainer().has(MODEL_ID_KEY, PersistentDataType.STRING)) {
            return;
        }
        event.setCancelled(true);
        String modelID = (String)item.getItemMeta().getPersistentDataContainer().get(MODEL_ID_KEY, PersistentDataType.STRING);
        if (!FileModelConverter.getConvertedFileModels().containsKey(modelID)) {
            Logger.sendMessage((CommandSender)player, "\u00a7cError: Model " + modelID + " no longer exists!");
            return;
        }
        RayTraceResult rayTraceResult = player.rayTraceBlocks(5.0);
        if (rayTraceResult == null || rayTraceResult.getHitBlock() == null) {
            Logger.sendMessage((CommandSender)player, "\u00a7cNo block found to place the model against!");
            return;
        }
        Block targetBlock = rayTraceResult.getHitBlock();
        BlockFace hitFace = rayTraceResult.getHitBlockFace();
        if (hitFace == null) {
            Logger.sendMessage((CommandSender)player, "\u00a7cCould not determine block face!");
            return;
        }
        Location placementLocation = targetBlock.getLocation().add(hitFace.getDirection());
        Vector toPlayer = player.getLocation().toVector().subtract(placementLocation.toVector()).normalize();
        float yaw = this.calculateYawFromDirection(toPlayer);
        placementLocation.setYaw(yaw);
        placementLocation.setPitch(0.0f);
        PropEntity staticEntity = PropEntity.spawnPropEntity(modelID, placementLocation);
        if (staticEntity != null) {
            Logger.sendMessage((CommandSender)player, "\u00a7aSuccessfully placed model " + modelID + "!");
        } else {
            Logger.sendMessage((CommandSender)player, "\u00a7cFailed to place model " + modelID + "!");
        }
    }

    private float calculateYawFromDirection(Vector direction) {
        double yaw = Math.atan2(-direction.getX(), direction.getZ()) * 180.0 / Math.PI;
        if ((yaw = (double)Math.round(yaw / 90.0) * 90.0) < 0.0) {
            yaw += 360.0;
        }
        return (float)yaw;
    }
}

