/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.magmacore.menus;

import com.magmaguy.freeminecraftmodels.magmacore.menus.MenuButton;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class ContentPackage
extends MenuButton {
    public ItemStack getItemstack() {
        return switch (this.getContentState()) {
            default -> throw new IncompatibleClassChangeError();
            case ContentState.INSTALLED -> this.getInstalledItemStack();
            case ContentState.PARTIALLY_INSTALLED -> this.getPartiallyInstalledItemStack();
            case ContentState.NOT_INSTALLED -> this.getNotInstalledItemStack();
            case ContentState.NOT_DOWNLOADED -> this.getNotDownloadedItemStack();
        };
    }

    protected abstract ItemStack getInstalledItemStack();

    protected abstract ItemStack getPartiallyInstalledItemStack();

    protected abstract ItemStack getNotInstalledItemStack();

    protected abstract ItemStack getNotDownloadedItemStack();

    protected abstract void doInstall(Player var1);

    protected abstract void doUninstall(Player var1);

    protected abstract void doDownload(Player var1);

    protected abstract ContentState getContentState();

    @Override
    public void onClick(Player player) {
        switch (this.getContentState()) {
            case INSTALLED: {
                this.doUninstall(player);
                break;
            }
            case PARTIALLY_INSTALLED: {
                this.doDownload(player);
                break;
            }
            case NOT_INSTALLED: {
                this.doInstall(player);
                break;
            }
            case NOT_DOWNLOADED: {
                this.doDownload(player);
            }
        }
    }

    public static enum ContentState {
        INSTALLED,
        PARTIALLY_INSTALLED,
        NOT_INSTALLED,
        NOT_DOWNLOADED;

    }
}

