/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.animation;

import com.magmaguy.freeminecraftmodels.animation.Animation;
import com.magmaguy.freeminecraftmodels.animation.AnimationStateConfig;
import com.magmaguy.freeminecraftmodels.animation.AnimationStateType;
import com.magmaguy.freeminecraftmodels.animation.IAnimState;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import java.util.Optional;

public class WalkState
implements IAnimState {
    private final ModeledEntity entity;
    private final AnimationStateConfig cfg;
    private AnimationStateType requestedNext;

    public WalkState(ModeledEntity entity, AnimationStateConfig cfg) {
        this.entity = entity;
        this.cfg = cfg;
    }

    @Override
    public void enter() {
        this.cfg.getAnimation().resetCounter();
    }

    @Override
    public void update() {
        this.requestedNext = null;
        if (!this.entity.getUnderlyingEntity().isOnGround()) {
            this.requestedNext = AnimationStateType.JUMP;
        } else if (this.entity.getUnderlyingEntity().getVelocity().length() <= 0.08) {
            this.requestedNext = AnimationStateType.IDLE;
        }
    }

    @Override
    public void exit() {
    }

    @Override
    public AnimationStateType getType() {
        return AnimationStateType.WALK;
    }

    @Override
    public Optional<AnimationStateType> nextState() {
        return Optional.ofNullable(this.requestedNext);
    }

    @Override
    public Animation getAnimation() {
        return this.cfg.getAnimation();
    }

    @Override
    public boolean isLoop() {
        return this.cfg.isLoop();
    }
}

