/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.commands;

import com.magmaguy.freeminecraftmodels.api.ModeledEntityManager;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.customentity.core.OrientedBoundingBox;
import com.magmaguy.freeminecraftmodels.magmacore.command.AdvancedCommand;
import com.magmaguy.freeminecraftmodels.magmacore.command.CommandData;
import com.magmaguy.freeminecraftmodels.magmacore.command.SenderType;
import com.magmaguy.freeminecraftmodels.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HitboxDebugCommand
extends AdvancedCommand {
    public HitboxDebugCommand() {
        super(List.of("hitbox"));
        this.addArgument("action", new ListStringCommandArgument(List.of("visualize"), "<action>"));
        this.addArgument("duration", new ListStringCommandArgument(List.of("60", "100", "200", "600"), "[duration]"));
        this.setDescription("Debug commands for OBB hitbox system");
        this.setPermission("freeminecraftmodels.*");
        this.setUsage("/fmm hitbox visualize [duration]");
        this.setSenderType(SenderType.PLAYER);
    }

    @Override
    public void execute(CommandData commandData) {
        List<ModeledEntity> nearbyEntities;
        Player player = commandData.getPlayerSender();
        int duration = 100;
        String durationArg = commandData.getStringArgument("duration");
        if (durationArg != null && !durationArg.isEmpty()) {
            try {
                duration = Integer.parseInt(durationArg);
                if (duration <= 0) {
                    duration = 100;
                } else if (duration > 1200) {
                    duration = 1200;
                }
            }
            catch (NumberFormatException e) {
                Logger.sendMessage((CommandSender)player, "Invalid duration. Using default of 5 seconds.");
            }
        }
        if ((nearbyEntities = ModeledEntityManager.getAllEntities().stream().filter(entity -> entity.getWorld() != null && entity.getWorld().equals(player.getWorld()) && entity.getLocation().distanceSquared(player.getLocation()) < 100.0).collect(Collectors.toList())).isEmpty()) {
            Logger.sendMessage((CommandSender)player, ChatColor.RED + "No modeled entities found nearby.");
            return;
        }
        int finalDuration = duration;
        nearbyEntities.forEach(entity -> {
            OrientedBoundingBox.visualizeOBB(entity, finalDuration, player);
            entity.showUnderlyingEntity(player);
        });
        Logger.sendMessage((CommandSender)player, ChatColor.GREEN + "Visualizing " + nearbyEntities.size() + " modeled entities for " + (double)finalDuration / 20.0 + " seconds.");
    }
}

