/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.commands;

import com.magmaguy.freeminecraftmodels.MetadataHandler;
import com.magmaguy.freeminecraftmodels.dataconverter.FileModelConverter;
import com.magmaguy.freeminecraftmodels.magmacore.command.AdvancedCommand;
import com.magmaguy.freeminecraftmodels.magmacore.command.CommandData;
import com.magmaguy.freeminecraftmodels.magmacore.command.SenderType;
import com.magmaguy.freeminecraftmodels.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class ItemifyCommand
extends AdvancedCommand {
    private final List<String> entityIDs = new ArrayList<String>();

    public ItemifyCommand() {
        super(List.of("itemify"));
        FileModelConverter.getConvertedFileModels().values().forEach(fileModelConverter -> this.entityIDs.add(fileModelConverter.getID()));
        this.addArgument("model", new ListStringCommandArgument(this.entityIDs, "<model>"));
        this.addArgument("material", new ListStringCommandArgument(List.of(Material.values()).stream().map(Enum::name).toList(), "<material>"));
        this.setDescription("Creates an item that can be used to place models");
        this.setPermission("freeminecraftmodels.*");
        this.setUsage("/fmm itemify <model> <material>");
        this.setSenderType(SenderType.PLAYER);
    }

    @Override
    public void execute(CommandData commandData) {
        Material material;
        Player player = commandData.getPlayerSender();
        String modelID = commandData.getStringArgument("model");
        String materialName = commandData.getStringArgument("material");
        if (!this.entityIDs.contains(modelID)) {
            Logger.sendMessage(commandData.getCommandSender(), "Invalid entity ID!");
            return;
        }
        try {
            material = Material.valueOf((String)materialName);
        }
        catch (IllegalArgumentException e) {
            Logger.sendMessage(commandData.getCommandSender(), "Invalid material: " + materialName);
            return;
        }
        ItemStack item = this.createModelItem(modelID, material);
        player.getInventory().addItem(new ItemStack[]{item});
        Logger.sendMessage((CommandSender)player, "You received a model placement item for: " + modelID);
    }

    private ItemStack createModelItem(String modelID, Material material) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a76Model Placer: " + modelID);
            meta.setLore(List.of("\u00a77Right-click to place the model", "\u00a77Model: " + modelID, "\u00a77Material: " + material.name()));
            NamespacedKey key = new NamespacedKey(MetadataHandler.PLUGIN, "model_id");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)modelID);
            item.setItemMeta(meta);
        }
        return item;
    }
}

