/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.commands;

import com.magmaguy.freeminecraftmodels.config.props.PropsConfig;
import com.magmaguy.freeminecraftmodels.config.props.PropsConfigFields;
import com.magmaguy.freeminecraftmodels.customentity.DynamicEntity;
import com.magmaguy.freeminecraftmodels.customentity.StaticEntity;
import com.magmaguy.freeminecraftmodels.dataconverter.FileModelConverter;
import com.magmaguy.freeminecraftmodels.magmacore.command.AdvancedCommand;
import com.magmaguy.freeminecraftmodels.magmacore.command.CommandData;
import com.magmaguy.freeminecraftmodels.magmacore.command.SenderType;
import com.magmaguy.freeminecraftmodels.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;

public class SpawnCommand
extends AdvancedCommand {
    List<String> spawnTypes = List.of("static", "dynamic", "prop");
    List<String> entityIDs = new ArrayList<String>();

    public SpawnCommand() {
        super(List.of("spawn"));
        this.addArgument("type", new ListStringCommandArgument(List.of("STATIC", "DYNAMIC", "PROP"), "<spawn>"));
        this.entityIDs = new ArrayList<String>();
        FileModelConverter.getConvertedFileModels().values().forEach(fileModelConverter -> this.entityIDs.add(fileModelConverter.getID()));
        this.addArgument("model", new ListStringCommandArgument(this.entityIDs, "<model>"));
        this.setDescription("Spawns custom models or creates props");
        this.setPermission("freeminecraftmodels.*");
        this.setUsage("/fmm spawn <static/dynamic/prop> <modelID>");
        this.setSenderType(SenderType.PLAYER);
    }

    @Override
    public void execute(CommandData commandData) {
        Player player = commandData.getPlayerSender();
        String modelID = commandData.getStringArgument("model");
        if (!this.entityIDs.contains(modelID)) {
            Logger.sendMessage(commandData.getCommandSender(), "Invalid entity ID!");
            return;
        }
        String type = commandData.getStringArgument("type").toLowerCase();
        if (type.equals("prop")) {
            this.createProp(player, modelID);
            return;
        }
        RayTraceResult rayTraceResult = player.rayTraceBlocks(300.0);
        if (rayTraceResult == null) {
            Logger.sendMessage(commandData.getCommandSender(), "You need to be looking at the ground to spawn a mob!");
            return;
        }
        Location location = rayTraceResult.getHitBlock().getLocation().add(0.5, 1.0, 0.5);
        location.setPitch(0.0f);
        location.setYaw(180.0f);
        if (type.equals("static")) {
            StaticEntity.create(modelID, location);
        } else if (type.equals("dynamic")) {
            DynamicEntity.create(modelID, (LivingEntity)location.getWorld().spawnEntity(location, EntityType.PIG));
        }
    }

    private void createProp(Player player, String propFilename) {
        PropsConfigFields prop = PropsConfig.addPropConfigurationFile(propFilename, player);
        prop.permanentlyAddLocation(player.getLocation());
        Logger.sendMessage((CommandSender)player, "Successfully added prop!");
    }
}

