/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.customentity.core;

import com.magmaguy.freeminecraftmodels.MetadataHandler;
import com.magmaguy.freeminecraftmodels.api.ModeledEntityManager;
import com.magmaguy.freeminecraftmodels.config.DefaultConfig;
import com.magmaguy.freeminecraftmodels.customentity.ModeledEntity;
import com.magmaguy.freeminecraftmodels.customentity.PropEntity;
import com.magmaguy.freeminecraftmodels.magmacore.util.AttributeManager;
import java.util.HashSet;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public class OrientedBoundingBox {
    private final Vector3d center = new Vector3d();
    private final Vector3d baseHalfExtents = new Vector3d();
    private final Vector3d halfExtents = new Vector3d();
    private final Matrix3d rotation = new Matrix3d().identity();
    private final Matrix3d inverseRotation = new Matrix3d().identity();
    private final Vector3d xAxis = new Vector3d();
    private final Vector3d yAxis = new Vector3d();
    private final Vector3d zAxis = new Vector3d();
    private final Vector3d[] cornerCache = new Vector3d[8];
    private final Vector3d rightTemp = new Vector3d();
    private final Vector3d upTemp = new Vector3d();
    private final Vector3d forwardTemp = new Vector3d();
    private final Vector3d localOriginCache = new Vector3d();
    private final Vector3d localDirCache = new Vector3d();
    private final double height;
    private double scaleModifier = 1.0;
    private boolean inverseRotationDirty = true;
    private Vector3d[] axes;
    private boolean cornersDirty = true;
    private boolean scaleDirty = true;
    private double currentYaw = 0.0;
    private Location lastLocation = null;
    private ModeledEntity associatedEntity = null;

    public OrientedBoundingBox(Vector3d center, double width, double height, double depth) {
        this.height = height;
        this.center.set((Vector3dc)center);
        this.baseHalfExtents.set(width / 2.0, height / 2.0, depth / 2.0);
        this.halfExtents.set((Vector3dc)this.baseHalfExtents);
        for (int i = 0; i < 8; ++i) {
            this.cornerCache[i] = new Vector3d();
        }
        this.updateAxes();
    }

    public OrientedBoundingBox(Vector3d center, double width, double height, double depth, ModeledEntity entity) {
        this(center, width, height, depth);
        this.associatedEntity = entity;
        this.updateScale();
    }

    public OrientedBoundingBox(Location location, double width, double height, double depth) {
        this(new Vector3d(location.getX(), location.getY() + height / 2.0, location.getZ()), width, height, depth);
    }

    public OrientedBoundingBox(Location location, double width, double height, double depth, ModeledEntity entity) {
        this(new Vector3d(location.getX(), location.getY() + height / 2.0, location.getZ()), width, height, depth, entity);
    }

    public static Optional<ModeledEntity> raytraceFromPlayer(Player player) {
        return OrientedBoundingBox.raytraceFromPoint(player.getWorld().getName(), player.getEyeLocation(), Math.max(DefaultConfig.maxInteractionAndAttackDistanceForLivingEntities, DefaultConfig.maxInteractionAndAttackDistanceForProps));
    }

    public static void visualizeOBB(final ModeledEntity entity, final int durationTicks, final Player player) {
        new BukkitRunnable(){
            private int ticksRemaining;
            {
                this.ticksRemaining = durationTicks;
            }

            public void run() {
                int[][] edges;
                if (this.ticksRemaining <= 0 || entity.getWorld() == null) {
                    this.cancel();
                    entity.hideUnderlyingEntity(player);
                    return;
                }
                OrientedBoundingBox obb = entity.getHitboxComponent().getObbHitbox();
                Vector3d[] corners = obb.getCorners();
                for (int[] edge : edges = new int[][]{{0, 1}, {1, 3}, {3, 2}, {2, 0}, {4, 5}, {5, 7}, {7, 6}, {6, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}}) {
                    Vector3d start = corners[edge[0]];
                    Vector3d end = corners[edge[1]];
                    int particleCount = 10;
                    for (int i = 0; i <= particleCount; ++i) {
                        float t = (float)i / (float)particleCount;
                        double x = start.x + (double)t * (end.x - start.x);
                        double y = start.y + (double)t * (end.y - start.y);
                        double z = start.z + (double)t * (end.z - start.z);
                        Location particleLoc = new Location(entity.getWorld(), x, y, z);
                        entity.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                --this.ticksRemaining;
            }
        }.runTaskTimer(MetadataHandler.PLUGIN, 0L, 1L);
    }

    public static Optional<ModeledEntity> raytraceFromPoint(String worldName, Location location, float maxDistance) {
        HashSet<ModeledEntity> entities = ModeledEntityManager.getAllEntities();
        entities.removeIf(entity -> entity.getWorld() == null || !entity.getWorld().getName().equals(worldName));
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        ModeledEntity closestEntity = null;
        double closestDistance = maxDistance;
        for (ModeledEntity entity2 : entities) {
            OrientedBoundingBox obb = entity2.getHitboxComponent().getObbHitbox();
            double distance = obb.rayIntersection(location, maxDistance);
            if (!(distance > 0.0) || !(distance < closestDistance) || entity2 instanceof PropEntity && distance > (double)DefaultConfig.maxInteractionAndAttackDistanceForProps || !(entity2 instanceof PropEntity) && distance > (double)DefaultConfig.maxInteractionAndAttackDistanceForLivingEntities) continue;
            closestEntity = entity2;
            closestDistance = distance;
        }
        return Optional.ofNullable(closestEntity);
    }

    private void updateScale() {
        Entity entity;
        if (this.associatedEntity == null) {
            if (this.scaleModifier != 1.0) {
                this.scaleModifier = 1.0;
                this.scaleDirty = true;
            }
            return;
        }
        double newScaleModifier = this.associatedEntity.getScaleModifier();
        Attribute scaleAttribute = AttributeManager.getAttribute("generic_scale");
        if (this.associatedEntity.getUnderlyingEntity() != null && (entity = this.associatedEntity.getUnderlyingEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (scaleAttribute != null && livingEntity.getAttribute(scaleAttribute) != null) {
                newScaleModifier *= livingEntity.getAttribute(scaleAttribute).getValue();
            }
        }
        if (Math.abs(newScaleModifier - this.scaleModifier) > 0.001) {
            this.scaleModifier = newScaleModifier;
            this.scaleDirty = true;
        }
    }

    private void updateHalfExtents() {
        if (this.scaleDirty) {
            this.halfExtents.set((Vector3dc)this.baseHalfExtents).mul(this.scaleModifier);
            this.cornersDirty = true;
            this.scaleDirty = false;
        }
    }

    public OrientedBoundingBox setAssociatedEntity(ModeledEntity entity) {
        this.associatedEntity = entity;
        this.updateScale();
        return this;
    }

    public OrientedBoundingBox update(Location location) {
        if (this.lastLocation != null && this.lastLocation.equals((Object)location)) {
            this.updateScale();
            this.updateHalfExtents();
            return this;
        }
        this.lastLocation = location;
        this.updateScale();
        this.updateHalfExtents();
        this.center.set(location.getX(), location.getY() + this.halfExtents.y, location.getZ());
        double yaw = Math.toRadians(-location.getYaw() - 90.0f);
        if (Math.abs(this.currentYaw - yaw) > 0.01) {
            this.currentYaw = yaw;
            this.rotation.identity().rotateY(yaw);
            this.inverseRotationDirty = true;
            this.updateAxes();
        }
        this.cornersDirty = true;
        return this;
    }

    private void updateAxes() {
        this.xAxis.set(1.0, 0.0, 0.0).mul((Matrix3dc)this.rotation);
        this.yAxis.set(0.0, 1.0, 0.0).mul((Matrix3dc)this.rotation);
        this.zAxis.set(0.0, 0.0, 1.0).mul((Matrix3dc)this.rotation);
        if (this.axes == null) {
            this.axes = new Vector3d[]{this.xAxis, this.yAxis, this.zAxis};
        }
    }

    public Vector3d[] getCorners() {
        this.updateHalfExtents();
        if (this.cornersDirty) {
            this.updateCorners();
        }
        return this.cornerCache;
    }

    private void updateCorners() {
        this.rightTemp.set((Vector3dc)this.axes[0]).mul(this.halfExtents.x);
        this.upTemp.set((Vector3dc)this.axes[1]).mul(this.halfExtents.y);
        this.forwardTemp.set((Vector3dc)this.axes[2]).mul(this.halfExtents.z);
        this.cornerCache[0].set((Vector3dc)this.center).add((Vector3dc)this.rightTemp).add((Vector3dc)this.upTemp).add((Vector3dc)this.forwardTemp);
        this.cornerCache[1].set((Vector3dc)this.center).add((Vector3dc)this.rightTemp).add((Vector3dc)this.upTemp).sub((Vector3dc)this.forwardTemp);
        this.cornerCache[2].set((Vector3dc)this.center).add((Vector3dc)this.rightTemp).sub((Vector3dc)this.upTemp).add((Vector3dc)this.forwardTemp);
        this.cornerCache[3].set((Vector3dc)this.center).add((Vector3dc)this.rightTemp).sub((Vector3dc)this.upTemp).sub((Vector3dc)this.forwardTemp);
        this.cornerCache[4].set((Vector3dc)this.center).sub((Vector3dc)this.rightTemp).add((Vector3dc)this.upTemp).add((Vector3dc)this.forwardTemp);
        this.cornerCache[5].set((Vector3dc)this.center).sub((Vector3dc)this.rightTemp).add((Vector3dc)this.upTemp).sub((Vector3dc)this.forwardTemp);
        this.cornerCache[6].set((Vector3dc)this.center).sub((Vector3dc)this.rightTemp).sub((Vector3dc)this.upTemp).add((Vector3dc)this.forwardTemp);
        this.cornerCache[7].set((Vector3dc)this.center).sub((Vector3dc)this.rightTemp).sub((Vector3dc)this.upTemp).sub((Vector3dc)this.forwardTemp);
        this.cornersDirty = false;
    }

    public double rayIntersection(Location eyeLocation, double maxDistance) {
        this.localOriginCache.set(eyeLocation.getX(), eyeLocation.getY(), eyeLocation.getZ());
        Vector dir = eyeLocation.getDirection();
        this.localDirCache.set(dir.getX(), dir.getY(), dir.getZ());
        Vector3d tempOrigin = this.localOriginCache.sub((Vector3dc)this.center);
        tempOrigin.mul((Matrix3dc)this.inverseRotation);
        this.localDirCache.mul((Matrix3dc)this.inverseRotation);
        double tMin = -1.7976931348623157E308;
        double tMax = Double.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            double d = this.localDirCache.get(i);
            double o = tempOrigin.get(i);
            double e = this.halfExtents.get(i);
            if (Math.abs(d) < 1.0E-6) {
                if (!(o > e) && !(o < -e)) continue;
                return -1.0;
            }
            double t1 = (-e - o) / d;
            double t2 = (e - o) / d;
            if (t1 > t2) {
                double temp = t1;
                t1 = t2;
                t2 = temp;
            }
            tMin = Math.max(tMin, t1);
            if (!((tMax = Math.min(tMax, t2)) < tMin)) continue;
            return -1.0;
        }
        if (tMin > maxDistance || tMax < 0.0) {
            return -1.0;
        }
        return tMin > 0.0 ? tMin : tMax;
    }

    public boolean isAABBCollidingWithOBB(BoundingBox aabb) {
        Vector3f aabbCenter = new Vector3f((float)((aabb.getMinX() + aabb.getMaxX()) / 2.0), (float)((aabb.getMinY() + aabb.getMaxY()) / 2.0), (float)((aabb.getMinZ() + aabb.getMaxZ()) / 2.0));
        Vector3f aabbHalfExtents = new Vector3f((float)((aabb.getMaxX() - aabb.getMinX()) / 2.0), (float)((aabb.getMaxY() - aabb.getMinY()) / 2.0), (float)((aabb.getMaxZ() - aabb.getMinZ()) / 2.0));
        Vector3d obbCenter = this.getCenter();
        Vector3d obbHalfExtents = this.getHalfExtents();
        double distX = Math.abs(obbCenter.x - (double)aabbCenter.x);
        double distY = Math.abs(obbCenter.y - (double)aabbCenter.y);
        double distZ = Math.abs(obbCenter.z - (double)aabbCenter.z);
        return distX < obbHalfExtents.x + (double)aabbHalfExtents.x && distY < obbHalfExtents.y + (double)aabbHalfExtents.y && distZ < obbHalfExtents.z + (double)aabbHalfExtents.z;
    }

    public boolean containsPoint(Location loc) {
        Vector3d local = new Vector3d(loc.getX(), loc.getY(), loc.getZ());
        local.sub((Vector3dc)this.center);
        local.mul((Matrix3dc)this.inverseRotation);
        return Math.abs(local.x) <= this.halfExtents.x && Math.abs(local.y) <= this.halfExtents.y && Math.abs(local.z) <= this.halfExtents.z;
    }

    public Vector3d getCenter() {
        return this.center;
    }

    public Vector3d getBaseHalfExtents() {
        return this.baseHalfExtents;
    }

    public Vector3d getHalfExtents() {
        return this.halfExtents;
    }

    public Matrix3d getRotation() {
        return this.rotation;
    }

    public double getScaleModifier() {
        return this.scaleModifier;
    }
}

