/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.dataconverter;

import com.google.gson.GsonBuilder;
import com.magmaguy.freeminecraftmodels.MetadataHandler;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import com.magmaguy.freeminecraftmodels.utils.StringToResourcePackFilename;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class ParsedTexture {
    private String filename;
    private double height;
    private double width;
    private double uvHeight;
    private double uvWidth;
    private double frameTime = 1.0;
    private Integer id;
    private boolean isValid = false;
    private String imagePath;

    public ParsedTexture(Map<?, ?> textureObject, String modelName, int imageIndex) {
        try {
            this.filename = StringToResourcePackFilename.convert((String)textureObject.get("name"));
            this.id = imageIndex;
            if (!this.filename.contains(".png")) {
                if (!this.filename.contains(".")) {
                    this.filename = this.filename + ".png";
                } else {
                    String[] stringArray = this.filename.split("\\.");
                    stringArray[0] = stringArray[0] + ".png";
                }
            }
            File imageFile = this.generateImageFile(textureObject, modelName);
            if (textureObject.get("height") != null) {
                this.height = (Double)textureObject.get("height");
                this.width = (Double)textureObject.get("width");
                this.uvHeight = (Double)textureObject.get("uv_height");
                this.uvWidth = (Double)textureObject.get("uv_width");
                this.frameTime = (Double)textureObject.get("frame_time");
            } else {
                BufferedImage bufferedImage = ImageIO.read(imageFile);
                this.height = bufferedImage.getHeight();
                this.width = bufferedImage.getWidth();
                if (this.height > this.width && this.height % this.width == 0.0) {
                    this.uvHeight = this.width;
                    this.uvWidth = this.width;
                    this.frameTime = 1.0;
                    Logger.info("Detected animated texture: " + this.filename + " (" + this.height / this.width + " frames)");
                } else {
                    this.uvHeight = bufferedImage.getHeight();
                    this.uvWidth = bufferedImage.getWidth();
                }
            }
        }
        catch (Exception e) {
            Logger.warn("Failed to parse texture " + textureObject.get("name") + "!");
            Logger.warn("JSON: " + textureObject);
            e.printStackTrace();
            this.isValid = false;
            return;
        }
        if (this.isAnimated()) {
            this.generateMCMetaFile();
        }
        this.isValid = true;
    }

    private File generateImageFile(Map<?, ?> textureObject, String modelName) {
        String base64Image = (String)textureObject.get("source");
        base64Image = base64Image.split(",")[base64Image.split(",").length - 1];
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)base64Image));
        this.imagePath = MetadataHandler.PLUGIN.getDataFolder().getAbsolutePath() + File.separatorChar + "output" + File.separatorChar + "FreeMinecraftModels" + File.separatorChar + "assets" + File.separatorChar + "freeminecraftmodels" + File.separatorChar + "textures" + File.separatorChar + "entity" + File.separatorChar + modelName + File.separatorChar + this.filename;
        File imageFile = new File(this.imagePath);
        try {
            FileUtils.writeByteArrayToFile(imageFile, inputStream.readAllBytes());
        }
        catch (IOException e) {
            Logger.warn("Failed to write image file " + imageFile.getAbsolutePath() + "!");
            throw new RuntimeException(e);
        }
        return imageFile;
    }

    private void generateMCMetaFile() {
        File mcMetaFile = new File(this.imagePath + ".mcmeta");
        AnimationMeta animationMeta = new AnimationMeta(this.frameTime);
        try {
            String json = new GsonBuilder().create().toJson(animationMeta);
            FileUtils.writeStringToFile(mcMetaFile, json, StandardCharsets.UTF_8);
            Logger.info("Created .mcmeta file for animated texture: " + this.filename);
        }
        catch (IOException e) {
            Logger.warn("Failed to write .mcmeta file " + mcMetaFile.getAbsolutePath() + "!");
            throw new RuntimeException(e);
        }
    }

    public boolean isAnimated() {
        return this.height != this.uvHeight || this.width != this.uvWidth;
    }

    public double getTextureHeight() {
        return this.uvHeight;
    }

    public double getTextureWidth() {
        return this.uvWidth;
    }

    public String getFilename() {
        return this.filename;
    }

    public double getFrameTime() {
        return this.frameTime;
    }

    public Integer getId() {
        return this.id;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private static class AnimationMeta {
        private final Animation animation;

        public AnimationMeta(double frametime) {
            this.animation = new Animation(frametime);
        }

        private static class Animation {
            private final double frametime;

            public Animation(double frametime) {
                this.frametime = frametime;
            }
        }
    }
}

