/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.magmacore.instance;

import com.magmaguy.freeminecraftmodels.magmacore.events.MatchInstantiateEvent;
import com.magmaguy.freeminecraftmodels.magmacore.instance.InstanceProtector;
import com.magmaguy.freeminecraftmodels.magmacore.instance.MatchInstance;
import com.magmaguy.freeminecraftmodels.magmacore.instance.MatchInstanceConfiguration;
import com.magmaguy.freeminecraftmodels.magmacore.instance.MatchInstanceInterface;
import com.magmaguy.freeminecraftmodels.magmacore.instance.MatchPlayer;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import com.magmaguy.freeminecraftmodels.magmacore.util.TemporaryWorldManager;
import java.io.File;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;

public class MatchInstanceWorld
extends MatchInstance
implements MatchInstanceInterface {
    private World world;
    private File worldDirectory;

    public MatchInstanceWorld(MatchInstanceConfiguration matchInstanceConfiguration, World world, File worldDirectory) {
        super(matchInstanceConfiguration);
        this.world = world;
        this.worldDirectory = worldDirectory;
        if (matchInstanceConfiguration.isProtected()) {
            InstanceProtector.addProtectedWorld(world);
        }
        if (matchInstanceConfiguration.isPvpPrevented()) {
            InstanceProtector.addPvpPreventedWorld(world);
        }
        if (matchInstanceConfiguration.isRedstonePrevented()) {
            InstanceProtector.addRedstonePreventedWorld(world);
        }
    }

    @Override
    public MatchInstantiateEvent start() {
        MatchInstantiateEvent matchInstantiateEvent = super.start();
        if (matchInstantiateEvent.isCancelled()) {
            return matchInstantiateEvent;
        }
        return matchInstantiateEvent;
    }

    @Override
    public void destroyMatch() {
        super.destroyMatch();
        TemporaryWorldManager.permanentlyDeleteWorld(this.world);
    }

    @Override
    public boolean isInRegion(Location location) {
        return location.getWorld().equals(this.world);
    }

    @Generated
    public World getWorld() {
        return this.world;
    }

    public static class MatchInstanceWorldEvents
    implements Listener {
        @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
        public void onPlayerTeleport(PlayerTeleportEvent event) {
            Logger.debug("Player " + event.getPlayer().getName() + " teleported to " + event.getTo().getWorld().getName());
            if (MatchInstance.MatchInstanceEvents.teleportBypass) {
                MatchInstance.MatchInstanceEvents.teleportBypass = false;
                return;
            }
            for (MatchInstance instance : MatchInstance.instances) {
                if (((MatchInstanceWorld)instance).world == null || !((MatchInstanceWorld)instance).world.equals(event.getFrom()) && !((MatchInstanceWorld)instance).world.equals(event.getTo())) continue;
                event.setCancelled(true);
                return;
            }
            MatchPlayer matchPlayer = MatchPlayer.getMatchPlayer(event.getPlayer());
            if (matchPlayer == null) {
                return;
            }
            if (matchPlayer.getMatchInstance().state == MatchInstance.InstanceState.WAITING) {
                return;
            }
            event.setCancelled(true);
        }
    }
}

