/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.commands;

import com.magmaguy.freeminecraftmodels.customentity.PlayerDisguiseEntity;
import com.magmaguy.freeminecraftmodels.dataconverter.FileModelConverter;
import com.magmaguy.freeminecraftmodels.magmacore.command.AdvancedCommand;
import com.magmaguy.freeminecraftmodels.magmacore.command.CommandData;
import com.magmaguy.freeminecraftmodels.magmacore.command.SenderType;
import com.magmaguy.freeminecraftmodels.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.List;

public class DisguiseCommand
extends AdvancedCommand {
    List<String> entityIDs = new ArrayList<String>();

    public DisguiseCommand() {
        super(List.of("disguise"));
        this.setDescription("Disguises a player as a model");
        this.setPermission("freeminecraftmodels.*");
        this.setDescription("/fmm disguise <modelID>");
        this.setSenderType(SenderType.PLAYER);
        this.entityIDs = new ArrayList<String>();
        FileModelConverter.getConvertedFileModels().values().forEach(fileModelConverter -> this.entityIDs.add(fileModelConverter.getID()));
        this.addArgument("models", new ListStringCommandArgument(this.entityIDs, "<modelID>"));
    }

    @Override
    public void execute(CommandData commandData) {
        if (!this.entityIDs.contains(commandData.getStringArgument("models"))) {
            Logger.sendMessage(commandData.getCommandSender(), "Invalid entity ID!");
            return;
        }
        PlayerDisguiseEntity.create(commandData.getStringArgument("models"), commandData.getPlayerSender());
    }
}

