/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.freeminecraftmodels.dataconverter;

import com.magmaguy.freeminecraftmodels.dataconverter.AnimationFrame;
import com.magmaguy.freeminecraftmodels.dataconverter.BoneBlueprint;
import com.magmaguy.freeminecraftmodels.dataconverter.Keyframe;
import com.magmaguy.freeminecraftmodels.dataconverter.SkeletonBlueprint;
import com.magmaguy.freeminecraftmodels.magmacore.util.Logger;
import com.magmaguy.freeminecraftmodels.magmacore.util.MathToolkit;
import com.magmaguy.freeminecraftmodels.utils.InterpolationType;
import com.magmaguy.freeminecraftmodels.utils.LoopType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnimationBlueprint {
    private final HashMap<BoneBlueprint, List<Keyframe>> boneKeyframes = new HashMap();
    private final HashMap<BoneBlueprint, AnimationFrame[]> animationFrames = new HashMap();
    private final int blockBenchVersion;
    private LoopType loopType;
    private String animationName;
    private SkeletonBlueprint skeletonBlueprint;
    private int duration;

    public AnimationBlueprint(Object data, String modelName, SkeletonBlueprint skeletonBlueprint, int blockBenchVersion) {
        Map animationData;
        this.blockBenchVersion = blockBenchVersion;
        try {
            animationData = (Map)data;
        }
        catch (Exception e) {
            Logger.warn("Failed to get animation data! Model format is not as expected, this version of BlockBench is not compatible with FreeMinecraftModels!");
            e.printStackTrace();
            return;
        }
        this.skeletonBlueprint = skeletonBlueprint;
        this.initializeGlobalValues(animationData);
        if (animationData.get("animators") == null) {
            return;
        }
        ((Map)animationData.get("animators")).entrySet().forEach(pair -> this.initializeBones((Map)pair.getValue(), modelName, this.animationName));
        try {
            this.interpolateKeyframes();
        }
        catch (Exception e) {
            Logger.warn("Failed to interpolate animations for model " + modelName + "! Animation name: " + this.animationName);
            e.printStackTrace();
        }
    }

    private void initializeGlobalValues(Map<String, Object> animationData) {
        this.animationName = (String)animationData.get("name");
        this.loopType = LoopType.valueOf(((String)animationData.get("loop")).toUpperCase());
        this.duration = (int)(20.0 * (Double)animationData.get("length"));
    }

    private void initializeBones(Map<String, Object> animationData, String modelName, String animationName) {
        String boneName = (String)animationData.get("name");
        BoneBlueprint boneBlueprint = this.skeletonBlueprint.getBoneMap().get(boneName);
        if (boneName.equalsIgnoreCase("hitbox")) {
            return;
        }
        if (boneBlueprint == null) {
            Logger.warn("Failed to get bone " + boneName + " from model " + modelName + "!");
            return;
        }
        if (animationData.get("keyframes") != null) {
            ArrayList<Keyframe> keyframes = new ArrayList<Keyframe>();
            for (Object keyframeData : (List)animationData.get("keyframes")) {
                keyframes.add(new Keyframe(keyframeData, modelName, animationName));
            }
            keyframes.sort(Comparator.comparingInt(Keyframe::getTimeInTicks));
            if (keyframes.size() >= 2) {
                this.addBoundaryKeyframes(keyframes);
            }
            this.boneKeyframes.put(boneBlueprint, keyframes);
        }
    }

    private void addBoundaryKeyframes(List<Keyframe> keyframes) {
        Keyframe lastKeyframe;
        if (keyframes.get(0).getTimeInTicks() > 0) {
            Keyframe firstKeyframe = keyframes.get(0);
            Keyframe startKeyframe = this.cloneKeyframeAtTime(firstKeyframe, 0);
            keyframes.add(0, startKeyframe);
        }
        if ((lastKeyframe = keyframes.get(keyframes.size() - 1)).getTimeInTicks() < this.duration - 1) {
            Keyframe endKeyframe = this.cloneKeyframeAtTime(lastKeyframe, this.duration - 1);
            keyframes.add(endKeyframe);
        }
    }

    private Keyframe cloneKeyframeAtTime(Keyframe original, int newTime) {
        return new Keyframe(original.getTransformationType(), original.getTimeInTicks(), original.getInterpolationType(), original.getDataX(), original.getDataY(), original.getDataZ());
    }

    private void interpolateKeyframes() {
        this.boneKeyframes.forEach(this::interpolateBoneKeyframes);
    }

    private void interpolateBoneKeyframes(BoneBlueprint boneBlueprint, List<Keyframe> keyframes) {
        ArrayList<Keyframe> rotationKeyframes = new ArrayList<Keyframe>();
        ArrayList<Keyframe> positionKeyframes = new ArrayList<Keyframe>();
        ArrayList<Keyframe> scaleKeyframes = new ArrayList<Keyframe>();
        for (Keyframe keyframe : keyframes) {
            switch (keyframe.getTransformationType()) {
                case ROTATION: {
                    rotationKeyframes.add(keyframe);
                    break;
                }
                case POSITION: {
                    positionKeyframes.add(keyframe);
                    break;
                }
                case SCALE: {
                    scaleKeyframes.add(keyframe);
                }
            }
        }
        AnimationFrame[] animationFramesArray = new AnimationFrame[this.duration];
        for (int i = 0; i < animationFramesArray.length; ++i) {
            animationFramesArray[i] = new AnimationFrame();
        }
        this.interpolateRotations(animationFramesArray, rotationKeyframes);
        this.interpolateTranslations(animationFramesArray, positionKeyframes);
        this.interpolateScales(animationFramesArray, scaleKeyframes);
        this.animationFrames.put(boneBlueprint, animationFramesArray);
    }

    private float interpolateWithType(InterpolationType type, float start, float end, float t) {
        switch (type) {
            case LINEAR: {
                return MathToolkit.lerp(start, end, t);
            }
            case CATMULLROM: {
                return MathToolkit.smoothLerp(start, end, t);
            }
            case BEZIER: {
                return MathToolkit.bezierLerp(start, end, t, 0.42f, 0.58f);
            }
            case STEP: {
                return MathToolkit.stepLerp(start, end, t);
            }
        }
        return MathToolkit.lerp(start, end, t);
    }

    private void interpolateRotations(AnimationFrame[] animationFramesArray, List<Keyframe> rotationKeyframes) {
        int durationBetweenKeyframes;
        Keyframe firstFrame = null;
        Keyframe previousFrame = null;
        Keyframe lastFrame = null;
        for (int i = 0; i < rotationKeyframes.size(); ++i) {
            Keyframe animationFrame = rotationKeyframes.get(i);
            if (i == 0) {
                firstFrame = animationFrame;
                previousFrame = animationFrame;
                lastFrame = animationFrame;
                continue;
            }
            if (previousFrame.getTimeInTicks() >= this.duration) {
                return;
            }
            int durationBetweenKeyframes2 = Math.min(animationFrame.getTimeInTicks(), this.duration) - previousFrame.getTimeInTicks();
            InterpolationType interpType = animationFrame.getInterpolationType();
            for (int j = 0; j < durationBetweenKeyframes2; ++j) {
                int currentFrame = j + previousFrame.getTimeInTicks();
                float t = (float)j / (float)durationBetweenKeyframes2;
                if (this.blockBenchVersion < 5) {
                    animationFramesArray[currentFrame].xRotation = this.interpolateWithType(interpType, previousFrame.getDataX(), animationFrame.getDataX(), t);
                    animationFramesArray[currentFrame].yRotation = this.interpolateWithType(interpType, previousFrame.getDataY(), animationFrame.getDataY(), t);
                    animationFramesArray[currentFrame].zRotation = this.interpolateWithType(interpType, previousFrame.getDataZ(), animationFrame.getDataZ(), t);
                    continue;
                }
                animationFramesArray[currentFrame].xRotation = -this.interpolateWithType(interpType, previousFrame.getDataX(), animationFrame.getDataX(), t);
                animationFramesArray[currentFrame].yRotation = -this.interpolateWithType(interpType, previousFrame.getDataY(), animationFrame.getDataY(), t);
                animationFramesArray[currentFrame].zRotation = this.interpolateWithType(interpType, previousFrame.getDataZ(), animationFrame.getDataZ(), t);
            }
            previousFrame = animationFrame;
            if (animationFrame.getTimeInTicks() > lastFrame.getTimeInTicks()) {
                lastFrame = animationFrame;
            }
            if (animationFrame.getTimeInTicks() >= firstFrame.getTimeInTicks()) continue;
            firstFrame = animationFrame;
        }
        if (lastFrame != null && lastFrame.getTimeInTicks() < this.duration - 1) {
            durationBetweenKeyframes = this.duration - lastFrame.getTimeInTicks();
            for (int j = 0; j < durationBetweenKeyframes; ++j) {
                int currentFrame = j + previousFrame.getTimeInTicks();
                if (this.blockBenchVersion < 5) {
                    animationFramesArray[currentFrame].xRotation = lastFrame.getDataX();
                    animationFramesArray[currentFrame].yRotation = lastFrame.getDataY();
                    animationFramesArray[currentFrame].zRotation = lastFrame.getDataZ();
                    continue;
                }
                animationFramesArray[currentFrame].xRotation = -lastFrame.getDataX();
                animationFramesArray[currentFrame].yRotation = -lastFrame.getDataY();
                animationFramesArray[currentFrame].zRotation = lastFrame.getDataZ();
            }
        }
        if (firstFrame != null && firstFrame.getTimeInTicks() > 0) {
            durationBetweenKeyframes = firstFrame.getTimeInTicks();
            durationBetweenKeyframes = Math.min(durationBetweenKeyframes, this.duration - 1);
            for (int j = 0; j < durationBetweenKeyframes; ++j) {
                if (this.blockBenchVersion < 5) {
                    animationFramesArray[j].xRotation = firstFrame.getDataX();
                    animationFramesArray[j].yRotation = firstFrame.getDataY();
                    animationFramesArray[j].zRotation = firstFrame.getDataZ();
                    continue;
                }
                animationFramesArray[j].xRotation = -firstFrame.getDataX();
                animationFramesArray[j].yRotation = -firstFrame.getDataY();
                animationFramesArray[j].zRotation = firstFrame.getDataZ();
            }
        }
    }

    private void interpolateTranslations(AnimationFrame[] animationFramesArray, List<Keyframe> positionKeyframes) {
        int durationBetweenKeyframes;
        Keyframe firstFrame = null;
        Keyframe previousFrame = null;
        Keyframe lastFrame = null;
        for (int i = 0; i < positionKeyframes.size(); ++i) {
            Keyframe animationFrame = positionKeyframes.get(i);
            if (i == 0) {
                firstFrame = animationFrame;
                previousFrame = animationFrame;
                lastFrame = animationFrame;
                continue;
            }
            int durationBetweenKeyframes2 = animationFrame.getTimeInTicks() - previousFrame.getTimeInTicks();
            InterpolationType interpType = animationFrame.getInterpolationType();
            for (int j = 0; j < durationBetweenKeyframes2; ++j) {
                int currentFrame = j + previousFrame.getTimeInTicks();
                float t = (float)j / (float)durationBetweenKeyframes2;
                if (this.blockBenchVersion < 5) {
                    animationFramesArray[currentFrame].xPosition = this.interpolateWithType(interpType, previousFrame.getDataX(), animationFrame.getDataX(), t) / 16.0f;
                    animationFramesArray[currentFrame].yPosition = this.interpolateWithType(interpType, previousFrame.getDataY(), animationFrame.getDataY(), t) / 16.0f;
                    animationFramesArray[currentFrame].zPosition = this.interpolateWithType(interpType, previousFrame.getDataZ(), animationFrame.getDataZ(), t) / 16.0f;
                    continue;
                }
                animationFramesArray[currentFrame].xPosition = -this.interpolateWithType(interpType, previousFrame.getDataX(), animationFrame.getDataX(), t) / 16.0f;
                animationFramesArray[currentFrame].yPosition = this.interpolateWithType(interpType, previousFrame.getDataY(), animationFrame.getDataY(), t) / 16.0f;
                animationFramesArray[currentFrame].zPosition = this.interpolateWithType(interpType, previousFrame.getDataZ(), animationFrame.getDataZ(), t) / 16.0f;
            }
            previousFrame = animationFrame;
            if (animationFrame.getTimeInTicks() > lastFrame.getTimeInTicks()) {
                lastFrame = animationFrame;
            }
            if (animationFrame.getTimeInTicks() >= firstFrame.getTimeInTicks()) continue;
            firstFrame = animationFrame;
        }
        if (lastFrame != null && lastFrame.getTimeInTicks() < this.duration - 1) {
            durationBetweenKeyframes = this.duration - lastFrame.getTimeInTicks();
            for (int j = 0; j < durationBetweenKeyframes; ++j) {
                int currentFrame = j + previousFrame.getTimeInTicks();
                if (this.blockBenchVersion < 5) {
                    animationFramesArray[currentFrame].xPosition = lastFrame.getDataX() / 16.0f;
                    animationFramesArray[currentFrame].yPosition = lastFrame.getDataY() / 16.0f;
                    animationFramesArray[currentFrame].zPosition = lastFrame.getDataZ() / 16.0f;
                    continue;
                }
                animationFramesArray[currentFrame].xPosition = -lastFrame.getDataX() / 16.0f;
                animationFramesArray[currentFrame].yPosition = lastFrame.getDataY() / 16.0f;
                animationFramesArray[currentFrame].zPosition = lastFrame.getDataZ() / 16.0f;
            }
        }
        if (firstFrame != null && firstFrame.getTimeInTicks() > 0) {
            durationBetweenKeyframes = firstFrame.getTimeInTicks();
            durationBetweenKeyframes = Math.min(durationBetweenKeyframes, this.duration - 1);
            for (int j = 0; j < durationBetweenKeyframes; ++j) {
                if (this.blockBenchVersion < 5) {
                    animationFramesArray[j].xPosition = firstFrame.getDataX() / 16.0f;
                    animationFramesArray[j].yPosition = firstFrame.getDataY() / 16.0f;
                    animationFramesArray[j].zPosition = firstFrame.getDataZ() / 16.0f;
                    continue;
                }
                animationFramesArray[j].xPosition = -firstFrame.getDataX() / 16.0f;
                animationFramesArray[j].yPosition = firstFrame.getDataY() / 16.0f;
                animationFramesArray[j].zPosition = firstFrame.getDataZ() / 16.0f;
            }
        }
    }

    private void interpolateScales(AnimationFrame[] animationFramesArray, List<Keyframe> scaleKeyframes) {
        Keyframe previousFrame = null;
        for (int i = 0; i < scaleKeyframes.size(); ++i) {
            Keyframe animationFrame = scaleKeyframes.get(i);
            if (i == 0) {
                previousFrame = animationFrame;
                continue;
            }
            int durationBetweenKeyframes = animationFrame.getTimeInTicks() - previousFrame.getTimeInTicks();
            InterpolationType interpType = animationFrame.getInterpolationType();
            for (int j = 0; j < durationBetweenKeyframes; ++j) {
                int currentFrame = j + previousFrame.getTimeInTicks();
                float t = (float)j / (float)durationBetweenKeyframes;
                animationFramesArray[currentFrame].scale = Float.valueOf(this.interpolateWithType(interpType, previousFrame.getDataX(), animationFrame.getDataX(), t));
            }
            previousFrame = animationFrame;
        }
    }

    public HashMap<BoneBlueprint, List<Keyframe>> getBoneKeyframes() {
        return this.boneKeyframes;
    }

    public HashMap<BoneBlueprint, AnimationFrame[]> getAnimationFrames() {
        return this.animationFrames;
    }

    public LoopType getLoopType() {
        return this.loopType;
    }

    public String getAnimationName() {
        return this.animationName;
    }

    public int getDuration() {
        return this.duration;
    }
}

