/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcs.network.packets.data.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcs.network.AbstractPacket;
import kamkeel.npcs.network.PacketChannel;
import kamkeel.npcs.network.PacketHandler;
import kamkeel.npcs.network.enums.EnumDataPacket;
import kamkeel.npcs.util.ByteBufUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.client.gui.util.IGuiClose;

public final class GuiClosePacket
extends AbstractPacket {
    public static final String packetName = "Data|GuiClose";
    private int code;
    private NBTTagCompound compound;

    public GuiClosePacket() {
    }

    public GuiClosePacket(int code, NBTTagCompound compound) {
        this.code = code;
        this.compound = compound;
    }

    public static void closeGUI(EntityPlayerMP playerMP, int closeCode, NBTTagCompound compound) {
        GuiClosePacket packet = new GuiClosePacket(closeCode, compound);
        PacketHandler.Instance.sendToPlayer(packet, playerMP);
    }

    @Override
    public Enum getType() {
        return EnumDataPacket.GUI_CLOSE;
    }

    @Override
    public PacketChannel getChannel() {
        return PacketHandler.DATA_PACKET;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        out.writeInt(this.code);
        ByteBufUtils.writeNBT(out, this.compound);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof IGuiClose) {
            int closeCode = in.readInt();
            NBTTagCompound nbt = ByteBufUtils.readNBT(in);
            ((IGuiClose)gui).setClose(closeCode, nbt);
        }
        Minecraft.func_71410_x().func_147108_a(null);
        Minecraft.func_71410_x().func_71381_h();
    }
}

