/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.script;

import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kamkeel.npcs.network.packets.request.script.ForgeScriptPacket;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import noppes.npcs.NBTTags;
import noppes.npcs.client.gui.script.GuiScriptInterface;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.data.ForgeDataScript;
import org.apache.commons.lang3.StringUtils;

public class GuiScriptForge
extends GuiScriptInterface {
    private final ForgeDataScript script = new ForgeDataScript();

    public GuiScriptForge() {
        this.hookList.add("init");
        ArrayList list = new ArrayList();
        try {
            list.addAll(ClassPath.from((ClassLoader)this.getClass().getClassLoader()).getTopLevelClassesRecursive("cpw.mods.fml.common.gameevent"));
            list.addAll(ClassPath.from((ClassLoader)this.getClass().getClassLoader()).getTopLevelClassesRecursive("net.minecraftforge.event"));
            list.removeAll((Collection<?>)ClassPath.from((ClassLoader)this.getClass().getClassLoader()).getTopLevelClassesRecursive("net.minecraftforge.event.terraingen"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (ClassPath.ClassInfo e1 : list) {
            ClassPath.ClassInfo classLoader = e1;
            Class infoClass = classLoader.load();
            ArrayList c = new ArrayList(Arrays.asList(infoClass.getDeclaredClasses()));
            if (c.isEmpty()) {
                c.add(infoClass);
            }
            for (Class<?> c1 : c) {
                if (EntityEvent.EntityConstructing.class.isAssignableFrom(c1) || WorldEvent.PotentialSpawns.class.isAssignableFrom(c1) || TickEvent.RenderTickEvent.class.isAssignableFrom(c1) || TickEvent.ClientTickEvent.class.isAssignableFrom(c1) || FMLNetworkEvent.ClientCustomPacketEvent.class.isAssignableFrom(c1) || ItemTooltipEvent.class.isAssignableFrom(c1) || !Event.class.isAssignableFrom(c1) || Modifier.isAbstract(c1.getModifiers()) || !Modifier.isPublic(c1.getModifiers()) || ChunkEvent.class.isAssignableFrom(c1) || ChunkWatchEvent.class.isAssignableFrom(c1) || ChunkDataEvent.class.isAssignableFrom(c1)) continue;
                String eventName = c1.getName();
                int i = eventName.lastIndexOf(".");
                eventName = StringUtils.uncapitalize((String)eventName.substring(i + 1).replace("$", ""));
                this.hookList.add(eventName);
            }
        }
        this.hookList.add("onCNPCNaturalSpawn");
        this.handler = this.script;
        ForgeScriptPacket.Get();
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (compound.func_74764_b("LoadComplete")) {
            this.loaded = true;
            return;
        }
        if (!compound.func_74764_b("Tab")) {
            this.script.setLanguage(compound.func_74779_i("ScriptLanguage"));
            this.script.setEnabled(compound.func_74767_n("ScriptEnabled"));
            super.setGuiData(compound);
        } else {
            int tab = compound.func_74762_e("Tab");
            ScriptContainer container = new ScriptContainer(this.script);
            container.readFromNBT(compound.func_74775_l("Script"));
            if (this.script.getScripts().isEmpty()) {
                for (int i = 0; i < compound.func_74762_e("TotalScripts"); ++i) {
                    this.script.getScripts().add(new ScriptContainer(this.script));
                }
            }
            this.script.getScripts().set(tab, container);
            this.func_73866_w_();
        }
    }

    @Override
    public void save() {
        if (this.loaded) {
            super.save();
            List<ScriptContainer> containers = this.script.getScripts();
            for (int i = 0; i < containers.size(); ++i) {
                ScriptContainer container = containers.get(i);
                ForgeScriptPacket.Save(i, containers.size(), container.writeToNBT(new NBTTagCompound()));
            }
            NBTTagCompound scriptData = new NBTTagCompound();
            scriptData.func_74778_a("ScriptLanguage", this.script.getLanguage());
            scriptData.func_74757_a("ScriptEnabled", this.script.getEnabled());
            scriptData.func_74782_a("ScriptConsole", (NBTBase)NBTTags.NBTLongStringMap(this.script.getConsoleText()));
            ForgeScriptPacket.Save(-1, containers.size(), scriptData);
        }
    }
}

