/*
 * Decompiled with CFR 0.152.
 */
package com.bytespacegames.requeue;

import com.bytespacegames.requeue.ConfigManager;
import com.bytespacegames.requeue.LocationManager;
import com.bytespacegames.requeue.PartyManager;
import com.bytespacegames.requeue.auto.IAutoRequeue;
import com.bytespacegames.requeue.auto.WhoRequeue;
import com.bytespacegames.requeue.commands.Requeue;
import com.bytespacegames.requeue.commands.RequeuePartyList;
import com.bytespacegames.requeue.commands.Rq;
import com.bytespacegames.requeue.listeners.ChatListener;
import com.bytespacegames.requeue.listeners.TickListener;
import com.bytespacegames.requeue.listeners.WorldListener;
import com.bytespacegames.requeue.settings.BooleanSetting;
import com.bytespacegames.requeue.settings.Setting;
import com.bytespacegames.requeue.util.Timer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;

@Mod(modid="requeuemod", version="1.0.9")
public class RequeueMod {
    public static final String MODID = "requeuemod";
    public static final String VERSION = "1.0.9";
    public static final String MOD_PREFIX = "space's requeue";
    public static final String PRIMARY_COLOR = "\u00a7c";
    public static final String TEXT_COLOR = "\u00a7e";
    private final Timer requeueTimer = new Timer();
    public static RequeueMod instance;
    private ChatListener chatHandler;
    private TickListener tickListener;
    private IAutoRequeue req = new WhoRequeue();
    private final List<Setting> settings = new ArrayList<Setting>();
    private final String[] excludedGames = new String[]{"BEDWARS", "PAINTBALL", "QUAKECRAFT", "ARENA", "GINGERBREAD", "WALLS3", "PIT", "SKYBLOCK", "REPLAY", "HOUSING"};

    public List<Setting> getSettings() {
        return this.settings;
    }

    public void registerSettings() {
        this.settings.add(new BooleanSetting("auto", "Automatically requeues when your party is dead.", false));
        this.settings.add(new BooleanSetting("safeguard", "Prevents you from using /requeue when your party is still alive.", true));
        this.settings.add(new BooleanSetting("kickoffline", "Automatically kicks offline players 5 seconds after they disconnect.", true));
        this.settings.add(new BooleanSetting("clientplayer", "Considers the client player (you) when requeueing. If off, it will requeue when your party is dead, even if you're alive.", true));
        this.settings.add(new BooleanSetting("requeueonwin", "Automatically requeues when the game is over.", false));
        this.settings.add(new BooleanSetting("hypixelonly", "Only runs any of the mods functions when connected to a hypixel server.", true));
        this.settings.add(new BooleanSetting("useforge", "Prefer forge event handlers. This can fix issues if another mod is conflicting with the mod.", false));
    }

    public Setting getSettingByName(String name) {
        for (Setting s : this.settings) {
            if (!s.getName().trim().equalsIgnoreCase(name.trim())) continue;
            return s;
        }
        return null;
    }

    public String[] settingsToArray() {
        String[] settingNames = new String[this.settings.size()];
        for (int i = 0; i < this.settings.size(); ++i) {
            settingNames[i] = this.settings.get(i).getName();
        }
        return settingNames;
    }

    public IAutoRequeue getRequeue() {
        return this.req;
    }

    public ChatListener getChatHandler() {
        return this.chatHandler;
    }

    public TickListener getTickListener() {
        return this.tickListener;
    }

    public void setRequeue(IAutoRequeue rq) {
        this.req = rq;
    }

    public boolean modEnabled() {
        if (Minecraft.func_71410_x().func_147104_D() == null || Minecraft.func_71410_x().func_147104_D().field_78845_b == null) {
            return false;
        }
        if (this.getSettingByName("hypixelonly").isEnabled()) {
            String ip = Minecraft.func_71410_x().func_147104_D().field_78845_b.toLowerCase();
            return ip.contains("hypixel.net") || ip.contains("hypixel.io");
        }
        return true;
    }

    public boolean isUsingWhoRequeue() {
        if (this.req == null) {
            return false;
        }
        if (LocationManager.instance == null) {
            return false;
        }
        return this.req instanceof WhoRequeue;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        instance = this;
        this.registerSettings();
        ConfigManager.loadSettings();
        this.chatHandler = new ChatListener();
        MinecraftForge.EVENT_BUS.register((Object)this.chatHandler);
        this.tickListener = new TickListener();
        MinecraftForge.EVENT_BUS.register((Object)this.tickListener);
        MinecraftForge.EVENT_BUS.register((Object)new WorldListener());
        ClientCommandHandler.instance.func_71555_a().remove("requeue");
        ClientCommandHandler.instance.func_71555_a().remove("rq");
        ClientCommandHandler.instance.func_71560_a((ICommand)new Requeue());
        ClientCommandHandler.instance.func_71560_a((ICommand)new Rq());
        ClientCommandHandler.instance.func_71560_a((ICommand)new RequeuePartyList());
        new LocationManager();
        new PartyManager();
    }

    public Timer getRequeueTimer() {
        return this.requeueTimer;
    }

    public String[] getExcludedGames() {
        return this.excludedGames;
    }
}

