/*
 * Decompiled with CFR 0.152.
 */
package com.bytespacegames.requeue.auto;

import com.bytespacegames.requeue.LocationManager;
import com.bytespacegames.requeue.PartyManager;
import com.bytespacegames.requeue.RequeueMod;
import com.bytespacegames.requeue.auto.IAutoRequeue;
import com.bytespacegames.requeue.util.ChatUtil;
import com.bytespacegames.requeue.util.GameUtil;
import com.bytespacegames.requeue.util.Timer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.network.NetworkPlayerInfo;

public class WhoRequeue
implements IAutoRequeue {
    private final Timer whoTimer = new Timer();
    private List<String> lastTickNames = new ArrayList<String>();
    private final List<String> whoNames = new ArrayList<String>();
    private boolean delayedValid = false;
    private boolean unhandledPlayer = false;
    private final String[] exceptions = new String[]{"SKYWARS", "WALLS", "MCGO"};

    public void setDelayedValid(boolean b) {
        this.delayedValid = b;
    }

    public void handlePlayer() {
        this.unhandledPlayer = true;
    }

    private boolean isWhoValid() {
        if (LocationManager.instance.getType().equalsIgnoreCase("SURVIVAL_GAMES") && this.whoNames.size() == 1) {
            try {
                int number = Integer.parseInt(this.whoNames.get(0));
                if (number <= 99) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (Arrays.asList(this.exceptions).contains(LocationManager.instance.getType().toUpperCase().trim())) {
            return this.delayedValid;
        }
        return true;
    }

    public void addWhoName(String name) {
        if (name.isEmpty()) {
            return;
        }
        this.whoNames.add(name.trim());
    }

    public void clearWhoNames() {
        this.whoNames.clear();
    }

    private boolean playerLeft(List<String> from, List<String> to) {
        for (String s : from) {
            if (to.contains(s)) continue;
            return true;
        }
        return false;
    }

    public void handleSendWho() {
        ArrayList<String> names = new ArrayList<String>();
        for (NetworkPlayerInfo n : Minecraft.func_71410_x().func_147114_u().func_175106_d()) {
            names.add(n.func_178845_a().getName().toLowerCase().trim());
        }
        this.unhandledPlayer = this.playerLeft(this.lastTickNames, names) || this.unhandledPlayer;
        boolean canRecheckWho = this.whoNames.isEmpty() || this.playerLeft(this.lastTickNames, names);
        this.lastTickNames = names;
        if ((canRecheckWho || this.unhandledPlayer) && LocationManager.instance.getMode() != null && this.whoTimer.hasTimeElapsed(5000L, true)) {
            Minecraft.func_71410_x().field_71439_g.func_71165_d("/who");
            RequeueMod.instance.getChatHandler().criteria.clear();
            if (LocationManager.instance.getType().equalsIgnoreCase("SKYWARS")) {
                RequeueMod.instance.getChatHandler().criteria.add("Mode:");
            }
            RequeueMod.instance.getChatHandler().criteria.add("ONLINE:");
            RequeueMod.instance.getChatHandler().criteria.add("ALIVE:");
            RequeueMod.instance.getChatHandler().criteria.add("This command is not available on this server!");
            RequeueMod.instance.getChatHandler().criteria.add("Couldn't find players, sorry!");
            RequeueMod.instance.getChatHandler().criteria.add("Command not supported!");
            RequeueMod.instance.getChatHandler().criteria.add("This command is not available while player names are scrambled!");
            RequeueMod.instance.getChatHandler().criteria.add("Game hasn't started yet!");
            RequeueMod.instance.getChatHandler().criteria.add("You cannot use that right now!");
            RequeueMod.instance.getChatHandler().criteria.add("You cannot use this right now.");
            RequeueMod.instance.getChatHandler().criteria.add("None!");
            RequeueMod.instance.getChatHandler().criteria.add("Picked Teams");
            RequeueMod.instance.getChatHandler().criteria.add("Players Alive");
            RequeueMod.instance.getChatHandler().criteria.add("Cops:");
            this.unhandledPlayer = false;
        }
    }

    @Override
    public boolean canRequeue() {
        for (String s : this.whoNames) {
            if (!PartyManager.instance.partyContains(s)) continue;
            return false;
        }
        if (RequeueMod.instance.getSettingByName("clientplayer").isEnabled()) {
            return !this.whoNames.contains(Minecraft.func_71410_x().field_71439_g.func_70005_c_().trim());
        }
        return true;
    }

    @Override
    public void requeueCleanup() {
        this.lastTickNames.clear();
        this.clearWhoNames();
    }

    @Override
    public void onTick() {
        if (!LocationManager.instance.isLocrawValid()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiDownloadTerrain) {
            return;
        }
        if (!RequeueMod.instance.getSettingByName("auto").isEnabled()) {
            return;
        }
        if ((LocationManager.instance.getType().equalsIgnoreCase("SKYWARS") || LocationManager.instance.getType().equalsIgnoreCase("SURVIVAL_GAMES")) && (LocationManager.instance.getMode().contains("teams") || LocationManager.instance.getMode().contains("mega"))) {
            return;
        }
        this.handleSendWho();
        if (this.whoNames.isEmpty()) {
            return;
        }
        if (this.isWhoValid() && this.canRequeue() && RequeueMod.instance.getRequeueTimer().hasTimeElapsed(10000L, true)) {
            String s = GameUtil.getGameID(LocationManager.instance.getType(), LocationManager.instance.getMode());
            if (s == null) {
                ChatUtil.displayMessageWithColor("There was an issue finding your game mode right now!");
                return;
            }
            ChatUtil.displayMessageWithColor("Attempted requeue.");
            this.requeueCleanup();
            Minecraft.func_71410_x().field_71439_g.func_71165_d("/play " + s);
        }
    }
}

