/*
 * Decompiled with CFR 0.152.
 */
package com.bytespacegames.requeue.listeners;

import com.bytespacegames.requeue.LocationManager;
import com.bytespacegames.requeue.PartyManager;
import com.bytespacegames.requeue.RequeueMod;
import com.bytespacegames.requeue.auto.WhoRequeue;
import com.bytespacegames.requeue.util.ChatUtil;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ChatListener
implements Mod.EventHandler {
    public final List<String> criteria = new ArrayList<String>();
    private long waitingSince = Long.MAX_VALUE;
    private final String[] wallsColors = new String[]{"RED", "BLUE", "GREEN", "YELLOW"};

    public void listenForJoins(String noColors) {
        if (noColors.contains(":")) {
            return;
        }
        if (noColors.startsWith("You left the party.")) {
            PartyManager.instance.clearParty();
            return;
        }
        if (noColors.startsWith("You have joined") && noColors.contains("'s party")) {
            PartyManager.instance.clearParty();
            String player = noColors.split(" ")[3];
            if (player.contains("[")) {
                player = noColors.split(" ")[4];
            }
            player = player.substring(0, player.length() - 2);
            PartyManager.instance.registerPlayer(player);
            return;
        }
        if (noColors.contains("has left the party")) {
            String player = noColors.split(" ")[0];
            if (player.contains("[")) {
                player = noColors.split(" ")[1];
            }
            PartyManager.instance.removePlayer(player);
            return;
        }
        if (noColors.contains("has been removed from the party.") || noColors.contains("was removed from your party")) {
            String player = noColors.split(" ")[0];
            if (player.contains("[")) {
                player = noColors.split(" ")[1];
            }
            PartyManager.instance.removePlayer(player);
            return;
        }
        if (noColors.contains("joined the party")) {
            String player = noColors.split(" ")[0];
            if (player.contains("[")) {
                player = noColors.split(" ")[1];
            }
            PartyManager.instance.registerPlayer(player);
            return;
        }
        if (noColors.startsWith("Kicked") && noColors.endsWith("because they were offline.")) {
            String[] args = noColors.split(" ");
            for (int i = 1; i < args.length - 4; ++i) {
                String player = args[i];
                if (player.contains("[")) continue;
                if (player.endsWith(",")) {
                    player = player.substring(0, player.length() - 1);
                }
                PartyManager.instance.removePlayer(player);
            }
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (noColors.contains("has disconnected") && RequeueMod.instance.getSettingByName("kickoffline").isEnabled()) {
            RequeueMod.instance.getTickListener().prepareKickOffline();
        }
    }

    public void listenForParty(String msg) {
        String[] args;
        String noColors = ChatUtil.removeColorCodes(msg).trim();
        this.listenForJoins(noColors);
        if (!noColors.contains(":")) {
            return;
        }
        if (!noColors.startsWith("You'll be partying")) {
            return;
        }
        String secondHalf = noColors.split(":", 2)[1];
        for (String s : args = secondHalf.split(",\\s*|\\s+")) {
            if (s.contains("[")) continue;
            PartyManager.instance.registerPlayer(s);
        }
    }

    public void parseAsWho(String message) {
        String[] playerList = message.split(":", 2)[1].split(",");
        ((WhoRequeue)RequeueMod.instance.getRequeue()).clearWhoNames();
        for (String p : playerList) {
            ((WhoRequeue)RequeueMod.instance.getRequeue()).addWhoName(p.trim());
        }
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent e) {
        String[] timeArgs;
        if (!RequeueMod.instance.modEnabled()) {
            return;
        }
        String message = e.message.func_150260_c();
        if (message.contains("\u00a7cspace's requeue")) {
            return;
        }
        String removedColors = ChatUtil.removeColorCodes(message).trim();
        if ((removedColors.contains("Reward Summary") || removedColors.contains("WINNER!") || removedColors.contains("GAME WIN - ")) && !removedColors.contains(":") && RequeueMod.instance.getSettingByName("requeueonwin").isEnabled()) {
            RequeueMod.instance.getTickListener().onGameEnd();
        }
        this.listenForParty(message);
        if (message.startsWith("{\"server\":")) {
            LocationManager.instance.setLocraw(message);
        }
        if (LocationManager.instance.isLocrawValid() && LocationManager.instance.getMode() != null && LocationManager.instance.getMode().equalsIgnoreCase("DROPPER") && RequeueMod.instance.isUsingWhoRequeue() && message.contains(":") && (timeArgs = message.split(":", 2)).length >= 1 && timeArgs[0].contains("finished all maps")) {
            ((WhoRequeue)RequeueMod.instance.getRequeue()).handlePlayer();
        }
        if (RequeueMod.instance.isUsingWhoRequeue() && removedColors.startsWith("ONLINE:") || removedColors.startsWith("ALIVE:")) {
            this.parseAsWho(removedColors);
        }
        this.hideCriteria(removedColors, e);
        if (RequeueMod.instance.isUsingWhoRequeue() && LocationManager.instance.getType() != null) {
            switch (LocationManager.instance.getType().toUpperCase()) {
                case "SKYWARS": {
                    this.handleSkywars(removedColors);
                    break;
                }
                case "WALLS": {
                    this.handleWalls(removedColors);
                    break;
                }
                case "MCGO": {
                    this.handleCVC(removedColors);
                }
            }
        }
    }

    public void hideCriteria(String message, ClientChatReceivedEvent e) {
        if (this.criteria.isEmpty()) {
            return;
        }
        boolean blocked = false;
        for (String s : this.criteria) {
            if (!message.contains(s)) continue;
            e.setCanceled(true);
            blocked = true;
            break;
        }
        if (blocked) {
            this.criteria.clear();
            this.waitingSince = Long.MAX_VALUE;
            if (message.startsWith("ALIVE:")) {
                this.criteria.add("DEAD:");
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (RequeueMod.instance.isUsingWhoRequeue() && LocationManager.instance.getType() != null && !LocationManager.instance.getType().equalsIgnoreCase("SKYWARS")) {
            ((WhoRequeue)RequeueMod.instance.getRequeue()).setDelayedValid(false);
        }
        if (!this.criteria.isEmpty() && this.waitingSince == Long.MAX_VALUE) {
            this.waitingSince = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.waitingSince > 5000L) {
            this.criteria.clear();
            this.waitingSince = Long.MAX_VALUE;
        }
    }

    public void handleSkywars(String message) {
        if (message.startsWith("Mode:")) {
            ((WhoRequeue)RequeueMod.instance.getRequeue()).clearWhoNames();
            this.criteria.add("Team #");
            ((WhoRequeue)RequeueMod.instance.getRequeue()).setDelayedValid(false);
            return;
        }
        if (!message.startsWith("Team #")) {
            this.criteria.clear();
            ((WhoRequeue)RequeueMod.instance.getRequeue()).setDelayedValid(true);
            return;
        }
        String playerName = message.split(" ")[2];
        ((WhoRequeue)RequeueMod.instance.getRequeue()).addWhoName(playerName);
        this.criteria.add("Team #");
    }

    public void handleWalls(String message) {
        if (message.startsWith("Players Alive")) {
            ((WhoRequeue)RequeueMod.instance.getRequeue()).clearWhoNames();
            this.criteria.add("RED: ");
            ((WhoRequeue)RequeueMod.instance.getRequeue()).setDelayedValid(false);
            return;
        }
        for (String color : this.wallsColors) {
            String[] playerNames;
            if (!message.startsWith(color + ": ")) continue;
            if (!color.equals("YELLOW")) {
                this.criteria.add(this.getNextColor(color) + ": ");
            }
            for (String playerName : playerNames = message.split(": ", 2)[1].trim().split(", ")) {
                ((WhoRequeue)RequeueMod.instance.getRequeue()).addWhoName(playerName.trim());
            }
            break;
        }
        if (message.startsWith("YELLOW: ")) {
            ((WhoRequeue)RequeueMod.instance.getRequeue()).setDelayedValid(true);
        }
    }

    public void handleCVC(String message) {
        if (message.startsWith("Crims: ") || message.startsWith("Cops: ")) {
            String[] playerNames;
            if (message.startsWith("Cops: ")) {
                ((WhoRequeue)RequeueMod.instance.getRequeue()).clearWhoNames();
                this.criteria.add("Crims: ");
                ((WhoRequeue)RequeueMod.instance.getRequeue()).setDelayedValid(false);
                return;
            }
            for (String playerName : playerNames = message.split(": ", 2)[1].trim().split(", ")) {
                ((WhoRequeue)RequeueMod.instance.getRequeue()).addWhoName(playerName.trim());
            }
        }
        if (message.startsWith("Crims: ")) {
            ((WhoRequeue)RequeueMod.instance.getRequeue()).setDelayedValid(true);
        }
    }

    public String getNextColor(String color) {
        switch (color) {
            case "RED": {
                return "BLUE";
            }
            case "BLUE": {
                return "GREEN";
            }
            case "GREEN": {
                return "YELLOW";
            }
        }
        return "RED";
    }

    public Class<? extends Annotation> annotationType() {
        return null;
    }
}

