/*
 * Decompiled with CFR 0.152.
 */
package com.bytespacegames.requeue.listeners;

import com.bytespacegames.requeue.LocationManager;
import com.bytespacegames.requeue.RequeueMod;
import com.bytespacegames.requeue.auto.TabRequeue;
import com.bytespacegames.requeue.auto.WhoRequeue;
import com.bytespacegames.requeue.util.ChatUtil;
import com.bytespacegames.requeue.util.GameUtil;
import com.bytespacegames.requeue.util.Timer;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickListener
implements Mod.EventHandler {
    private final Timer locrawTimer = new Timer();
    private final Timer kickofflineTimer = new Timer();
    private final Timer endRequeueTimer = new Timer();
    private final Timer endTriggerTimer = new Timer();
    private boolean endRequeueTriggered = false;
    private boolean awaitingKickOffline = false;
    private boolean returnedLastTick = false;

    public void prepareKickOffline() {
        this.kickofflineTimer.reset();
        this.awaitingKickOffline = true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (!RequeueMod.instance.modEnabled()) {
            return;
        }
        this.handleKickOffline();
        this.handleLocraw();
        if (LocationManager.instance == null) {
            return;
        }
        if (LocationManager.instance.getType() == null) {
            this.endRequeueTriggered = false;
            return;
        }
        if (LocationManager.instance.getMode() == null) {
            this.endRequeueTriggered = false;
            return;
        }
        if (Arrays.asList(RequeueMod.instance.getExcludedGames()).contains(LocationManager.instance.getType().toUpperCase().trim())) {
            return;
        }
        this.handleWinRequeue();
        this.handleAuto();
    }

    public void handleKickOffline() {
        if (this.awaitingKickOffline && Minecraft.func_71410_x().field_71439_g != null && this.kickofflineTimer.hasTimeElapsed(5000L, true)) {
            this.awaitingKickOffline = false;
            Minecraft.func_71410_x().field_71439_g.func_71165_d("/p kickoffline");
        }
    }

    public void resetTimer() {
        this.locrawTimer.reset();
        this.endRequeueTriggered = false;
    }

    public void requeue() {
        RequeueMod.instance.getRequeueTimer().reset();
        String s = GameUtil.getGameID(LocationManager.instance.getType(), LocationManager.instance.getMode());
        if (s == null) {
            ChatUtil.displayMessageWithColor("There was an issue finding your game mode right now!");
            return;
        }
        ChatUtil.displayMessageWithColor("Attempted requeue.");
        RequeueMod.instance.getRequeue().requeueCleanup();
        Minecraft.func_71410_x().field_71439_g.func_71165_d("/play " + s);
    }

    public void handleWinRequeue() {
        if (Minecraft.func_71410_x().field_71441_e != null && this.endRequeueTriggered && this.endRequeueTimer.hasTimeElapsed(500L, false)) {
            this.endRequeueTriggered = false;
            this.requeue();
            return;
        }
    }

    public void handleAuto() {
        if (LocationManager.instance.getType().equals("DUELS")) {
            return;
        }
        if (LocationManager.instance.getType().equals("ARCADE") && LocationManager.instance.getMode().equals("PARTY")) {
            return;
        }
        boolean useTab = LocationManager.instance.getType().equals("PROTOTYPE");
        if (useTab && !(RequeueMod.instance.getRequeue() instanceof TabRequeue)) {
            RequeueMod.instance.setRequeue(new TabRequeue());
        }
        if (!useTab && !RequeueMod.instance.isUsingWhoRequeue()) {
            RequeueMod.instance.setRequeue(new WhoRequeue());
        }
        RequeueMod.instance.getRequeue().onTick();
    }

    public void handleLocraw() {
        if (!LocationManager.instance.isAwaitingLocraw()) {
            this.returnedLastTick = true;
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            this.returnedLastTick = true;
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            this.returnedLastTick = true;
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiDownloadTerrain) {
            this.returnedLastTick = true;
            return;
        }
        if (this.returnedLastTick) {
            this.locrawTimer.reset();
        }
        if (this.locrawTimer.hasTimeElapsed(5000L, true)) {
            LocationManager.instance.sendLocraw();
        }
        this.returnedLastTick = false;
    }

    public void onGameEnd() {
        if (this.endTriggerTimer.hasTimeElapsed(5000L, true) && RequeueMod.instance.getRequeueTimer().hasTimeElapsed(10000L, false)) {
            this.endRequeueTriggered = true;
            this.endRequeueTimer.reset();
        }
    }

    public Class<? extends Annotation> annotationType() {
        return null;
    }
}

