/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.subanuticaafterzero.client.renderer;

import net.mcreator.subanuticaafterzero.client.model.ModelArrowRay;
import net.mcreator.subanuticaafterzero.client.model.animations.ArrowRayAnimation;
import net.mcreator.subanuticaafterzero.entity.ArrowRayEntity;
import net.mcreator.subanuticaafterzero.procedures.FeatherFishLoopProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ArrowRayRenderer
extends MobRenderer<ArrowRayEntity, ModelArrowRay<ArrowRayEntity>> {
    public ArrowRayRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelArrowRay.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(ArrowRayEntity entity) {
        return ResourceLocation.parse((String)"subanuticaafterzero:textures/entities/arrowray.png");
    }

    private static final class AnimatedModel
    extends ModelArrowRay<ArrowRayEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<ArrowRayEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(ArrowRayEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                if (FeatherFishLoopProcedure.execute()) {
                    this.animateWalk(ArrowRayAnimation.swimming, limbSwing, limbSwingAmount, 2.0f, 1.0f);
                }
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(ArrowRayEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

