/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.subanuticaafterzero.entity;

import net.mcreator.subanuticaafterzero.entity.ArcticPeeperEntity;
import net.mcreator.subanuticaafterzero.entity.BladderFishEntity;
import net.mcreator.subanuticaafterzero.entity.BrinewingEntity;
import net.mcreator.subanuticaafterzero.entity.BruteSharksEntity;
import net.mcreator.subanuticaafterzero.entity.ChelicerateEntity;
import net.mcreator.subanuticaafterzero.entity.FeatherFishEntity;
import net.mcreator.subanuticaafterzero.entity.RedFeatherFishEntity;
import net.mcreator.subanuticaafterzero.procedures.BladderFishOnEntityTickUpdateProcedure;
import net.mcreator.subanuticaafterzero.procedures.PinnacairdEntityDiesProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class PinnacairdEntity
extends PathfinderMob {
    public PinnacairdEntity(EntityType<PinnacairdEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (PinnacairdEntity.this.isInWater()) {
                    PinnacairdEntity.this.setDeltaMovement(PinnacairdEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !PinnacairdEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - PinnacairdEntity.this.getX();
                    double dy = this.wantedY - PinnacairdEntity.this.getY();
                    double dz = this.wantedZ - PinnacairdEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * PinnacairdEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    PinnacairdEntity.this.setYRot(this.rotlerp(PinnacairdEntity.this.getYRot(), f, 10.0f));
                    PinnacairdEntity.this.yBodyRot = PinnacairdEntity.this.getYRot();
                    PinnacairdEntity.this.yHeadRot = PinnacairdEntity.this.getYRot();
                    if (PinnacairdEntity.this.isInWater()) {
                        PinnacairdEntity.this.setSpeed((float)PinnacairdEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        PinnacairdEntity.this.setXRot(this.rotlerp(PinnacairdEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(PinnacairdEntity.this.getXRot() * ((float)Math.PI / 180)));
                        PinnacairdEntity.this.setZza(f3 * f1);
                        PinnacairdEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        PinnacairdEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    PinnacairdEntity.this.setSpeed(0.0f);
                    PinnacairdEntity.this.setYya(0.0f);
                    PinnacairdEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 10.0));
        this.goalSelector.addGoal(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 8.0, 40));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 8.0));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, ChelicerateEntity.class, 25.0f, 10.0, 9.0));
        this.goalSelector.addGoal(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, BruteSharksEntity.class, 9.0f, 8.5, 9.0));
        this.goalSelector.addGoal(7, (Goal)new AvoidEntityGoal((PathfinderMob)this, FeatherFishEntity.class, 10.0f, 9.0, 2.8));
        this.goalSelector.addGoal(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, BladderFishEntity.class, 10.0f, 9.0, 2.8));
        this.goalSelector.addGoal(9, (Goal)new AvoidEntityGoal((PathfinderMob)this, ArcticPeeperEntity.class, 10.0f, 9.0, 2.8));
        this.goalSelector.addGoal(10, (Goal)new AvoidEntityGoal((PathfinderMob)this, RedFeatherFishEntity.class, 12.0f, 9.0, 2.8));
        this.goalSelector.addGoal(11, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 3.6, 9.0));
        this.goalSelector.addGoal(12, (Goal)new AvoidEntityGoal((PathfinderMob)this, BrinewingEntity.class, 9.0f, 3.6, 9.0));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"subanuticaafterzero:pinnacaridambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"subanuticaafterzero:pinnacaridhurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"subanuticaafterzero:pinnacarid_death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        PinnacairdEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void baseTick() {
        super.baseTick();
        BladderFishOnEntityTickUpdateProcedure.execute((Entity)this);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        PinnacairdEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        PinnacairdEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 9.3);
        builder = builder.add(Attributes.MAX_HEALTH, 50.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 9.3);
        return builder;
    }
}

