/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.subanuticaafterzero.network;

import java.util.function.Supplier;
import net.mcreator.subanuticaafterzero.SubanuticaafterzeroMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SubanuticaafterzeroModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"subanuticaafterzero");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SubanuticaafterzeroMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        SubanuticaafterzeroMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"subanuticaafterzero", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"subanuticaafterzero", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double checkhealth = 0.0;
        public double checkhunger = 0.0;
        public double checkthirst = 0.0;
        public double checko2 = 0.0;
        public double checkdepth = 0.0;
        public double Xheadptich = 0.0;
        public double Yheadptich = 0.0;
        public double Zheadptich = 0.0;
        public double forcetrucktickzero = 0.0;
        public double getseatruckdepth = 0.0;
        public double heavyo2truefalse = 0.0;
        public double whitetabletrecipe = 0.0;
        public double GoalCopperObtain = 0.0;
        public double GoalSilverObtain = 0.0;
        public double GoalDiamondObtain = 0.0;
        public double GoalWaterObtain = 0.0;
        public double GoalEnterVents = 0.0;
        public double GoalEnterLilypads = 0.0;
        public double GoalEnterVoid = 0.0;
        public double GoalEnterKelp = 0.0;
        public double GoalEnterShallows = 0.0;
        public double GoalUranium = 0.0;
        public double GoalCookedFish = 0.0;
        public double GoalScanner = 0.0;
        public double PickUpScanner = 0.0;
        public double PickUpFlashlight = 0.0;
        public double PickUpCrystal = 0.0;
        public double PickUpUranium = 0.0;
        public double PickUpTitanium = 0.0;
        public String ScannedRedTabletText = "\"\"";
        public double SetScannerCooldown = 0.0;
        public double ScannerCool = 0.0;
        public String ScannedSeaglideText = "\"\"";
        public double FlashlightOnOff = 0.0;
        public double IsPlayerInSurvival = 0.0;
        public double Enterbase = 0.0;
        public double basetimer = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("checkhealth", this.checkhealth);
            nbt.putDouble("checkhunger", this.checkhunger);
            nbt.putDouble("checkthirst", this.checkthirst);
            nbt.putDouble("checko2", this.checko2);
            nbt.putDouble("checkdepth", this.checkdepth);
            nbt.putDouble("Xheadptich", this.Xheadptich);
            nbt.putDouble("Yheadptich", this.Yheadptich);
            nbt.putDouble("Zheadptich", this.Zheadptich);
            nbt.putDouble("forcetrucktickzero", this.forcetrucktickzero);
            nbt.putDouble("getseatruckdepth", this.getseatruckdepth);
            nbt.putDouble("heavyo2truefalse", this.heavyo2truefalse);
            nbt.putDouble("whitetabletrecipe", this.whitetabletrecipe);
            nbt.putDouble("GoalCopperObtain", this.GoalCopperObtain);
            nbt.putDouble("GoalSilverObtain", this.GoalSilverObtain);
            nbt.putDouble("GoalDiamondObtain", this.GoalDiamondObtain);
            nbt.putDouble("GoalWaterObtain", this.GoalWaterObtain);
            nbt.putDouble("GoalEnterVents", this.GoalEnterVents);
            nbt.putDouble("GoalEnterLilypads", this.GoalEnterLilypads);
            nbt.putDouble("GoalEnterVoid", this.GoalEnterVoid);
            nbt.putDouble("GoalEnterKelp", this.GoalEnterKelp);
            nbt.putDouble("GoalEnterShallows", this.GoalEnterShallows);
            nbt.putDouble("GoalUranium", this.GoalUranium);
            nbt.putDouble("GoalCookedFish", this.GoalCookedFish);
            nbt.putDouble("GoalScanner", this.GoalScanner);
            nbt.putDouble("PickUpScanner", this.PickUpScanner);
            nbt.putDouble("PickUpFlashlight", this.PickUpFlashlight);
            nbt.putDouble("PickUpCrystal", this.PickUpCrystal);
            nbt.putDouble("PickUpUranium", this.PickUpUranium);
            nbt.putDouble("PickUpTitanium", this.PickUpTitanium);
            nbt.putString("ScannedRedTabletText", this.ScannedRedTabletText);
            nbt.putDouble("SetScannerCooldown", this.SetScannerCooldown);
            nbt.putDouble("ScannerCool", this.ScannerCool);
            nbt.putString("ScannedSeaglideText", this.ScannedSeaglideText);
            nbt.putDouble("FlashlightOnOff", this.FlashlightOnOff);
            nbt.putDouble("IsPlayerInSurvival", this.IsPlayerInSurvival);
            nbt.putDouble("Enterbase", this.Enterbase);
            nbt.putDouble("basetimer", this.basetimer);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.checkhealth = nbt.getDouble("checkhealth");
            this.checkhunger = nbt.getDouble("checkhunger");
            this.checkthirst = nbt.getDouble("checkthirst");
            this.checko2 = nbt.getDouble("checko2");
            this.checkdepth = nbt.getDouble("checkdepth");
            this.Xheadptich = nbt.getDouble("Xheadptich");
            this.Yheadptich = nbt.getDouble("Yheadptich");
            this.Zheadptich = nbt.getDouble("Zheadptich");
            this.forcetrucktickzero = nbt.getDouble("forcetrucktickzero");
            this.getseatruckdepth = nbt.getDouble("getseatruckdepth");
            this.heavyo2truefalse = nbt.getDouble("heavyo2truefalse");
            this.whitetabletrecipe = nbt.getDouble("whitetabletrecipe");
            this.GoalCopperObtain = nbt.getDouble("GoalCopperObtain");
            this.GoalSilverObtain = nbt.getDouble("GoalSilverObtain");
            this.GoalDiamondObtain = nbt.getDouble("GoalDiamondObtain");
            this.GoalWaterObtain = nbt.getDouble("GoalWaterObtain");
            this.GoalEnterVents = nbt.getDouble("GoalEnterVents");
            this.GoalEnterLilypads = nbt.getDouble("GoalEnterLilypads");
            this.GoalEnterVoid = nbt.getDouble("GoalEnterVoid");
            this.GoalEnterKelp = nbt.getDouble("GoalEnterKelp");
            this.GoalEnterShallows = nbt.getDouble("GoalEnterShallows");
            this.GoalUranium = nbt.getDouble("GoalUranium");
            this.GoalCookedFish = nbt.getDouble("GoalCookedFish");
            this.GoalScanner = nbt.getDouble("GoalScanner");
            this.PickUpScanner = nbt.getDouble("PickUpScanner");
            this.PickUpFlashlight = nbt.getDouble("PickUpFlashlight");
            this.PickUpCrystal = nbt.getDouble("PickUpCrystal");
            this.PickUpUranium = nbt.getDouble("PickUpUranium");
            this.PickUpTitanium = nbt.getDouble("PickUpTitanium");
            this.ScannedRedTabletText = nbt.getString("ScannedRedTabletText");
            this.SetScannerCooldown = nbt.getDouble("SetScannerCooldown");
            this.ScannerCool = nbt.getDouble("ScannerCool");
            this.ScannedSeaglideText = nbt.getString("ScannedSeaglideText");
            this.FlashlightOnOff = nbt.getDouble("FlashlightOnOff");
            this.IsPlayerInSurvival = nbt.getDouble("IsPlayerInSurvival");
            this.Enterbase = nbt.getDouble("Enterbase");
            this.basetimer = nbt.getDouble("basetimer");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "subanuticaafterzero_mapvars";
        public String temperaturestat = "";
        public double GoalSeaglide = 0.0;
        public double ScannedRedTablet = 0.0;
        public double ScannedSeaglide = 0.0;
        public double globalmeteortimer = 0.0;
        public double shootmeteorwhen = 0.0;
        public double eventshallows = 0.0;
        public double EventShallowsLock = 0.0;
        public double eventvents = 0.0;
        public double eventventslock = 0.0;
        public double surelia_choice_timer = 0.0;
        public double surelia_choice_lock = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.temperaturestat = nbt.getString("temperaturestat");
            this.GoalSeaglide = nbt.getDouble("GoalSeaglide");
            this.ScannedRedTablet = nbt.getDouble("ScannedRedTablet");
            this.ScannedSeaglide = nbt.getDouble("ScannedSeaglide");
            this.globalmeteortimer = nbt.getDouble("globalmeteortimer");
            this.shootmeteorwhen = nbt.getDouble("shootmeteorwhen");
            this.eventshallows = nbt.getDouble("eventshallows");
            this.EventShallowsLock = nbt.getDouble("EventShallowsLock");
            this.eventvents = nbt.getDouble("eventvents");
            this.eventventslock = nbt.getDouble("eventventslock");
            this.surelia_choice_timer = nbt.getDouble("surelia_choice_timer");
            this.surelia_choice_lock = nbt.getDouble("surelia_choice_lock");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putString("temperaturestat", this.temperaturestat);
            nbt.putDouble("GoalSeaglide", this.GoalSeaglide);
            nbt.putDouble("ScannedRedTablet", this.ScannedRedTablet);
            nbt.putDouble("ScannedSeaglide", this.ScannedSeaglide);
            nbt.putDouble("globalmeteortimer", this.globalmeteortimer);
            nbt.putDouble("shootmeteorwhen", this.shootmeteorwhen);
            nbt.putDouble("eventshallows", this.eventshallows);
            nbt.putDouble("EventShallowsLock", this.EventShallowsLock);
            nbt.putDouble("eventvents", this.eventvents);
            nbt.putDouble("eventventslock", this.eventventslock);
            nbt.putDouble("surelia_choice_timer", this.surelia_choice_timer);
            nbt.putDouble("surelia_choice_lock", this.surelia_choice_lock);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "subanuticaafterzero_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.checkhealth = original.checkhealth;
            clone.checkhunger = original.checkhunger;
            clone.checkthirst = original.checkthirst;
            clone.checko2 = original.checko2;
            clone.checkdepth = original.checkdepth;
            clone.Xheadptich = original.Xheadptich;
            clone.Yheadptich = original.Yheadptich;
            clone.Zheadptich = original.Zheadptich;
            clone.forcetrucktickzero = original.forcetrucktickzero;
            clone.getseatruckdepth = original.getseatruckdepth;
            clone.whitetabletrecipe = original.whitetabletrecipe;
            clone.GoalCopperObtain = original.GoalCopperObtain;
            clone.GoalSilverObtain = original.GoalSilverObtain;
            clone.GoalDiamondObtain = original.GoalDiamondObtain;
            clone.GoalWaterObtain = original.GoalWaterObtain;
            clone.GoalEnterVents = original.GoalEnterVents;
            clone.GoalEnterLilypads = original.GoalEnterLilypads;
            clone.GoalEnterVoid = original.GoalEnterVoid;
            clone.GoalEnterKelp = original.GoalEnterKelp;
            clone.GoalEnterShallows = original.GoalEnterShallows;
            clone.GoalUranium = original.GoalUranium;
            clone.GoalCookedFish = original.GoalCookedFish;
            clone.GoalScanner = original.GoalScanner;
            clone.PickUpScanner = original.PickUpScanner;
            clone.PickUpFlashlight = original.PickUpFlashlight;
            clone.PickUpCrystal = original.PickUpCrystal;
            clone.PickUpUranium = original.PickUpUranium;
            clone.PickUpTitanium = original.PickUpTitanium;
            clone.ScannedRedTabletText = original.ScannedRedTabletText;
            clone.SetScannerCooldown = original.SetScannerCooldown;
            clone.ScannerCool = original.ScannerCool;
            clone.ScannedSeaglideText = original.ScannedSeaglideText;
            clone.FlashlightOnOff = original.FlashlightOnOff;
            clone.IsPlayerInSurvival = original.IsPlayerInSurvival;
            clone.Enterbase = original.Enterbase;
            clone.basetimer = original.basetimer;
            if (!event.isWasDeath()) {
                clone.heavyo2truefalse = original.heavyo2truefalse;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

