/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.subanuticaafterzero.block;

import net.mcreator.subanuticaafterzero.block.entity.PrecursorFanBlockEntity;
import net.mcreator.subanuticaafterzero.procedures.PrecursorFanOnTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.DeferredSoundType;

public class PrecursorFanBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public PrecursorFanBlock(BlockBehaviour.Properties properties) {
        super(properties.sound((SoundType)new DeferredSoundType(1.0f, 1.0f, () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.metal.break")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"subanuticaafterzero:precusorstep")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.metal.place")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.metal.hit")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.metal.fall")))).strength(1.0f, 10.0f).lightLevel(s -> 4).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)PrecursorFanBlock.box((double)-16.0, (double)0.0, (double)-6.0, (double)25.0, (double)5.0, (double)22.0), (VoxelShape[])new VoxelShape[]{PrecursorFanBlock.box((double)13.0, (double)5.0, (double)-6.0, (double)25.0, (double)9.0, (double)22.0), PrecursorFanBlock.box((double)-4.0, (double)5.0, (double)-6.0, (double)13.0, (double)9.0, (double)0.0), PrecursorFanBlock.box((double)-4.0, (double)5.0, (double)16.0, (double)13.0, (double)9.0, (double)22.0), PrecursorFanBlock.box((double)-16.0, (double)5.0, (double)-6.0, (double)-4.0, (double)9.0, (double)22.0), PrecursorFanBlock.box((double)-16.0, (double)0.0, (double)-13.0, (double)32.0, (double)16.0, (double)-6.0), PrecursorFanBlock.box((double)22.0, (double)0.0, (double)-6.0, (double)25.0, (double)18.0, (double)-3.0), PrecursorFanBlock.box((double)22.0, (double)0.0, (double)19.0, (double)25.0, (double)18.0, (double)22.0), PrecursorFanBlock.box((double)-16.0, (double)0.0, (double)22.0, (double)32.0, (double)16.0, (double)29.0), PrecursorFanBlock.box((double)22.0, (double)16.0, (double)22.0, (double)32.0, (double)18.0, (double)29.0), PrecursorFanBlock.box((double)22.0, (double)16.0, (double)-13.0, (double)32.0, (double)18.0, (double)-6.0), PrecursorFanBlock.box((double)25.0, (double)16.0, (double)-6.0, (double)32.0, (double)18.0, (double)-3.0), PrecursorFanBlock.box((double)25.0, (double)16.0, (double)19.0, (double)32.0, (double)18.0, (double)22.0), PrecursorFanBlock.box((double)25.0, (double)0.0, (double)-6.0, (double)32.0, (double)16.0, (double)22.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)PrecursorFanBlock.box((double)-9.0, (double)0.0, (double)-6.0, (double)32.0, (double)5.0, (double)22.0), (VoxelShape[])new VoxelShape[]{PrecursorFanBlock.box((double)-9.0, (double)5.0, (double)-6.0, (double)3.0, (double)9.0, (double)22.0), PrecursorFanBlock.box((double)3.0, (double)5.0, (double)16.0, (double)20.0, (double)9.0, (double)22.0), PrecursorFanBlock.box((double)3.0, (double)5.0, (double)-6.0, (double)20.0, (double)9.0, (double)0.0), PrecursorFanBlock.box((double)20.0, (double)5.0, (double)-6.0, (double)32.0, (double)9.0, (double)22.0), PrecursorFanBlock.box((double)-16.0, (double)0.0, (double)22.0, (double)32.0, (double)16.0, (double)29.0), PrecursorFanBlock.box((double)-9.0, (double)0.0, (double)19.0, (double)-6.0, (double)18.0, (double)22.0), PrecursorFanBlock.box((double)-9.0, (double)0.0, (double)-6.0, (double)-6.0, (double)18.0, (double)-3.0), PrecursorFanBlock.box((double)-16.0, (double)0.0, (double)-13.0, (double)32.0, (double)16.0, (double)-6.0), PrecursorFanBlock.box((double)-16.0, (double)16.0, (double)-13.0, (double)-6.0, (double)18.0, (double)-6.0), PrecursorFanBlock.box((double)-16.0, (double)16.0, (double)22.0, (double)-6.0, (double)18.0, (double)29.0), PrecursorFanBlock.box((double)-16.0, (double)16.0, (double)19.0, (double)-9.0, (double)18.0, (double)22.0), PrecursorFanBlock.box((double)-16.0, (double)16.0, (double)-6.0, (double)-9.0, (double)18.0, (double)-3.0), PrecursorFanBlock.box((double)-16.0, (double)0.0, (double)-6.0, (double)-9.0, (double)16.0, (double)22.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)PrecursorFanBlock.box((double)-6.0, (double)0.0, (double)-9.0, (double)22.0, (double)5.0, (double)32.0), (VoxelShape[])new VoxelShape[]{PrecursorFanBlock.box((double)-6.0, (double)5.0, (double)-9.0, (double)22.0, (double)9.0, (double)3.0), PrecursorFanBlock.box((double)-6.0, (double)5.0, (double)3.0, (double)0.0, (double)9.0, (double)20.0), PrecursorFanBlock.box((double)16.0, (double)5.0, (double)3.0, (double)22.0, (double)9.0, (double)20.0), PrecursorFanBlock.box((double)-6.0, (double)5.0, (double)20.0, (double)22.0, (double)9.0, (double)32.0), PrecursorFanBlock.box((double)-13.0, (double)0.0, (double)-16.0, (double)-6.0, (double)16.0, (double)32.0), PrecursorFanBlock.box((double)-6.0, (double)0.0, (double)-9.0, (double)-3.0, (double)18.0, (double)-6.0), PrecursorFanBlock.box((double)19.0, (double)0.0, (double)-9.0, (double)22.0, (double)18.0, (double)-6.0), PrecursorFanBlock.box((double)22.0, (double)0.0, (double)-16.0, (double)29.0, (double)16.0, (double)32.0), PrecursorFanBlock.box((double)22.0, (double)16.0, (double)-16.0, (double)29.0, (double)18.0, (double)-6.0), PrecursorFanBlock.box((double)-13.0, (double)16.0, (double)-16.0, (double)-6.0, (double)18.0, (double)-6.0), PrecursorFanBlock.box((double)-6.0, (double)16.0, (double)-16.0, (double)-3.0, (double)18.0, (double)-9.0), PrecursorFanBlock.box((double)19.0, (double)16.0, (double)-16.0, (double)22.0, (double)18.0, (double)-9.0), PrecursorFanBlock.box((double)-6.0, (double)0.0, (double)-16.0, (double)22.0, (double)16.0, (double)-9.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)PrecursorFanBlock.box((double)-6.0, (double)0.0, (double)-16.0, (double)22.0, (double)5.0, (double)25.0), (VoxelShape[])new VoxelShape[]{PrecursorFanBlock.box((double)-6.0, (double)5.0, (double)13.0, (double)22.0, (double)9.0, (double)25.0), PrecursorFanBlock.box((double)16.0, (double)5.0, (double)-4.0, (double)22.0, (double)9.0, (double)13.0), PrecursorFanBlock.box((double)-6.0, (double)5.0, (double)-4.0, (double)0.0, (double)9.0, (double)13.0), PrecursorFanBlock.box((double)-6.0, (double)5.0, (double)-16.0, (double)22.0, (double)9.0, (double)-4.0), PrecursorFanBlock.box((double)22.0, (double)0.0, (double)-16.0, (double)29.0, (double)16.0, (double)32.0), PrecursorFanBlock.box((double)19.0, (double)0.0, (double)22.0, (double)22.0, (double)18.0, (double)25.0), PrecursorFanBlock.box((double)-6.0, (double)0.0, (double)22.0, (double)-3.0, (double)18.0, (double)25.0), PrecursorFanBlock.box((double)-13.0, (double)0.0, (double)-16.0, (double)-6.0, (double)16.0, (double)32.0), PrecursorFanBlock.box((double)-13.0, (double)16.0, (double)22.0, (double)-6.0, (double)18.0, (double)32.0), PrecursorFanBlock.box((double)22.0, (double)16.0, (double)22.0, (double)29.0, (double)18.0, (double)32.0), PrecursorFanBlock.box((double)19.0, (double)16.0, (double)25.0, (double)22.0, (double)18.0, (double)32.0), PrecursorFanBlock.box((double)-6.0, (double)16.0, (double)25.0, (double)-3.0, (double)18.0, (double)32.0), PrecursorFanBlock.box((double)-6.0, (double)0.0, (double)25.0, (double)22.0, (double)16.0, (double)32.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, world, scheduledTickAccess, currentPos, facing, facingPos, facingState, random);
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 1);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        PrecursorFanOnTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 1);
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PrecursorFanBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof PrecursorFanBlockEntity) {
                PrecursorFanBlockEntity be = (PrecursorFanBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof PrecursorFanBlockEntity) {
            PrecursorFanBlockEntity be = (PrecursorFanBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

