/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.subanuticaafterzero.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.subanuticaafterzero.block.IonCubeGrabberBlock;
import net.mcreator.subanuticaafterzero.block.entity.IonCubeGrabberBlockEntity;
import net.mcreator.subanuticaafterzero.client.model.Modelioncubegrabber;
import net.mcreator.subanuticaafterzero.client.model.animations.ioncubegrabberAnimation;
import net.mcreator.subanuticaafterzero.init.SubanuticaafterzeroModBlockEntities;
import net.mcreator.subanuticaafterzero.procedures.IonCubeGrabberPlaybackConditionProcedure;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class IonCubeGrabberRenderer
implements BlockEntityRenderer<IonCubeGrabberBlockEntity> {
    private final CustomHierarchicalModel model;
    private final ResourceLocation texture;
    private final LivingEntityRenderState renderState;

    IonCubeGrabberRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new CustomHierarchicalModel(context.bakeLayer(Modelioncubegrabber.LAYER_LOCATION));
        this.texture = ResourceLocation.parse((String)"subanuticaafterzero:textures/block/ioncubegrabber.png");
        this.renderState = new LivingEntityRenderState();
    }

    private void updateRenderState(IonCubeGrabberBlockEntity blockEntity, float partialTick) {
        int tickCount = (int)blockEntity.getLevel().getGameTime();
        this.renderState.ageInTicks = (float)tickCount + partialTick;
        blockEntity.animationState0.animateWhen(IonCubeGrabberPlaybackConditionProcedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
    }

    public void render(IonCubeGrabberBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource renderer, int light, int overlayLight) {
        this.updateRenderState(blockEntity, partialTick);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue(IonCubeGrabberBlock.FACING);
        switch (facing) {
            case NORTH: {
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.model.setupBlockEntityAnim(blockEntity, this.renderState);
        this.model.renderToBuffer(poseStack, builder, light, overlayLight);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)SubanuticaafterzeroModBlockEntities.ION_CUBE_GRABBER.get(), IonCubeGrabberRenderer::new);
    }

    private static final class CustomHierarchicalModel
    extends Modelioncubegrabber {
        public CustomHierarchicalModel(ModelPart root) {
            super(root);
        }

        public void setupBlockEntityAnim(IonCubeGrabberBlockEntity blockEntity, LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(blockEntity.animationState0, ioncubegrabberAnimation.activate, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }

        public ModelPart getRoot() {
            return this.root;
        }
    }
}

