/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.subanuticaafterzero.entity;

import net.mcreator.subanuticaafterzero.entity.ArcticPeeperEntity;
import net.mcreator.subanuticaafterzero.entity.BladderFishEntity;
import net.mcreator.subanuticaafterzero.entity.BrinewingEntity;
import net.mcreator.subanuticaafterzero.entity.FeatherFishEntity;
import net.mcreator.subanuticaafterzero.entity.RedFeatherFishEntity;
import net.mcreator.subanuticaafterzero.init.SubanuticaafterzeroModItems;
import net.mcreator.subanuticaafterzero.procedures.ArrowRayEntityDiesProcedure;
import net.mcreator.subanuticaafterzero.procedures.BladderFishOnEntityTickUpdateProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class ArrowRayEntity
extends PathfinderMob {
    public ArrowRayEntity(EntityType<ArrowRayEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (ArrowRayEntity.this.isInWater()) {
                    ArrowRayEntity.this.setDeltaMovement(ArrowRayEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !ArrowRayEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - ArrowRayEntity.this.getX();
                    double dy = this.wantedY - ArrowRayEntity.this.getY();
                    double dz = this.wantedZ - ArrowRayEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * ArrowRayEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    ArrowRayEntity.this.setYRot(this.rotlerp(ArrowRayEntity.this.getYRot(), f, 10.0f));
                    ArrowRayEntity.this.yBodyRot = ArrowRayEntity.this.getYRot();
                    ArrowRayEntity.this.yHeadRot = ArrowRayEntity.this.getYRot();
                    if (ArrowRayEntity.this.isInWater()) {
                        ArrowRayEntity.this.setSpeed((float)ArrowRayEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        ArrowRayEntity.this.setXRot(this.rotlerp(ArrowRayEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(ArrowRayEntity.this.getXRot() * ((float)Math.PI / 180)));
                        ArrowRayEntity.this.setZza(f3 * f1);
                        ArrowRayEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        ArrowRayEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    ArrowRayEntity.this.setSpeed(0.0f);
                    ArrowRayEntity.this.setYya(0.0f);
                    ArrowRayEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 9.0));
        this.goalSelector.addGoal(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 8.5, 40));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 8.5));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, FeatherFishEntity.class, 10.0f, 7.0, 2.8));
        this.goalSelector.addGoal(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, BladderFishEntity.class, 10.0f, 7.0, 2.8));
        this.goalSelector.addGoal(7, (Goal)new AvoidEntityGoal((PathfinderMob)this, ArcticPeeperEntity.class, 10.0f, 7.0, 2.8));
        this.goalSelector.addGoal(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, RedFeatherFishEntity.class, 12.0f, 7.0, 2.8));
        this.goalSelector.addGoal(9, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 7.0, 7.0));
        this.goalSelector.addGoal(10, (Goal)new AvoidEntityGoal((PathfinderMob)this, BrinewingEntity.class, 9.0f, 7.0, 7.0));
        this.goalSelector.addGoal(11, (Goal)new AvoidEntityGoal((PathfinderMob)this, ArrowRayEntity.class, 9.0f, 7.0, 7.0));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)SubanuticaafterzeroModItems.ARCTIC_PEEPER_ITEM.get()));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"subanuticaafterzero:fishswim"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.tropical_fish.hurt"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        ArrowRayEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void baseTick() {
        super.baseTick();
        BladderFishOnEntityTickUpdateProcedure.execute((Entity)this);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        ArrowRayEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        ArrowRayEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 9.0);
        builder = builder.add(Attributes.MAX_HEALTH, 3.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 1.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 9.0);
        return builder;
    }
}

