/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.subanuticaafterzero.entity;

import net.mcreator.subanuticaafterzero.entity.BrinewingEntity;
import net.mcreator.subanuticaafterzero.entity.ChelicerateEntity;
import net.mcreator.subanuticaafterzero.entity.PinnacairdEntity;
import net.mcreator.subanuticaafterzero.procedures.BladderFishOnEntityTickUpdateProcedure;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class BruteSharkEntity
extends Monster {
    public BruteSharkEntity(EntityType<BruteSharkEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (BruteSharkEntity.this.isInWater()) {
                    BruteSharkEntity.this.setDeltaMovement(BruteSharkEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !BruteSharkEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - BruteSharkEntity.this.getX();
                    double dy = this.wantedY - BruteSharkEntity.this.getY();
                    double dz = this.wantedZ - BruteSharkEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * BruteSharkEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    BruteSharkEntity.this.setYRot(this.rotlerp(BruteSharkEntity.this.getYRot(), f, 10.0f));
                    BruteSharkEntity.this.yBodyRot = BruteSharkEntity.this.getYRot();
                    BruteSharkEntity.this.yHeadRot = BruteSharkEntity.this.getYRot();
                    if (BruteSharkEntity.this.isInWater()) {
                        BruteSharkEntity.this.setSpeed((float)BruteSharkEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        BruteSharkEntity.this.setXRot(this.rotlerp(BruteSharkEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(BruteSharkEntity.this.getXRot() * ((float)Math.PI / 180)));
                        BruteSharkEntity.this.setZza(f3 * f1);
                        BruteSharkEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        BruteSharkEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    BruteSharkEntity.this.setSpeed(0.0f);
                    BruteSharkEntity.this.setYya(0.0f);
                    BruteSharkEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, ChelicerateEntity.class, 20.0f, 1.0, 1.2));
        this.goalSelector.addGoal(3, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, BrinewingEntity.class, false, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, PinnacairdEntity.class, false, true));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void baseTick() {
        super.baseTick();
        BladderFishOnEntityTickUpdateProcedure.execute((Entity)this);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        BruteSharkEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        BruteSharkEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 6.0);
        builder = builder.add(Attributes.MAX_HEALTH, 200.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 6.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 20.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 10.0);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 6.0);
        return builder;
    }
}

