/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.subanuticaafterzero.entity;

import net.mcreator.subanuticaafterzero.entity.BrinewingEntity;
import net.mcreator.subanuticaafterzero.entity.BruteSharksEntity;
import net.mcreator.subanuticaafterzero.entity.ChelicerateEntity;
import net.mcreator.subanuticaafterzero.procedures.LilypaddlerEntityDiesProcedure;
import net.mcreator.subanuticaafterzero.procedures.LilypaddlerOnEntityTickUpdateProcedure;
import net.mcreator.subanuticaafterzero.procedures.LilypaddlerPlaybackConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class LilypaddlerEntity
extends Monster {
    public final AnimationState animationState0 = new AnimationState();

    public LilypaddlerEntity(EntityType<LilypaddlerEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (LilypaddlerEntity.this.isInWater()) {
                    LilypaddlerEntity.this.setDeltaMovement(LilypaddlerEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !LilypaddlerEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - LilypaddlerEntity.this.getX();
                    double dy = this.wantedY - LilypaddlerEntity.this.getY();
                    double dz = this.wantedZ - LilypaddlerEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * LilypaddlerEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    LilypaddlerEntity.this.setYRot(this.rotlerp(LilypaddlerEntity.this.getYRot(), f, 10.0f));
                    LilypaddlerEntity.this.yBodyRot = LilypaddlerEntity.this.getYRot();
                    LilypaddlerEntity.this.yHeadRot = LilypaddlerEntity.this.getYRot();
                    if (LilypaddlerEntity.this.isInWater()) {
                        LilypaddlerEntity.this.setSpeed((float)LilypaddlerEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        LilypaddlerEntity.this.setXRot(this.rotlerp(LilypaddlerEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(LilypaddlerEntity.this.getXRot() * ((float)Math.PI / 180)));
                        LilypaddlerEntity.this.setZza(f3 * f1);
                        LilypaddlerEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        LilypaddlerEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    LilypaddlerEntity.this.setSpeed(0.0f);
                    LilypaddlerEntity.this.setYya(0.0f);
                    LilypaddlerEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 2.0, 40));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 20.0f, 1.0, 1.2));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, ChelicerateEntity.class, 20.0f, 1.0, 1.2));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, BruteSharksEntity.class, 20.0f, 1.0, 1.2));
        this.goalSelector.addGoal(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, BrinewingEntity.class, 20.0f, 1.0, 1.2));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"subanuticaafterzero:lilypaddlerhurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"subanuticaafterzero:lilypaddlerdeath"));
    }

    public void die(DamageSource source) {
        super.die(source);
        LilypaddlerEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(LilypaddlerPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        LilypaddlerOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        LilypaddlerEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        LilypaddlerEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 3.5);
        builder = builder.add(Attributes.MAX_HEALTH, 100.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 30.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 3.5);
        return builder;
    }
}

