/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs;

import com.google.common.base.Preconditions;
import com.itsschatten.libs.Utils;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class InteractiveMessages {
    private BaseComponent current;
    private final List<BaseComponent> parts = new ArrayList<BaseComponent>();

    public InteractiveMessages(@NotNull InteractiveMessages original) {
        this.current = original.current.duplicate();
        for (BaseComponent baseComponent : original.parts) {
            this.parts.add(baseComponent.duplicate());
        }
    }

    public InteractiveMessages(String text) {
        this.current = new TextComponent(new BaseComponent[]{TextComponent.fromLegacy((String)Utils.colorize(text))});
    }

    public InteractiveMessages(@NotNull BaseComponent component) {
        this.current = component.duplicate();
    }

    public InteractiveMessages append(BaseComponent component) {
        return this.append(component, ComponentBuilder.FormatRetention.ALL);
    }

    @Contract(value="_, _ -> this")
    public InteractiveMessages append(@NotNull BaseComponent component, ComponentBuilder.FormatRetention retention) {
        this.parts.add(this.current);
        BaseComponent previous = this.current;
        this.current = component.duplicate();
        this.current.copyFormatting(previous, retention, false);
        return this;
    }

    public InteractiveMessages append(BaseComponent[] components) {
        return this.append(components, ComponentBuilder.FormatRetention.ALL);
    }

    @Contract(value="_, _ -> this")
    public InteractiveMessages append(BaseComponent @NotNull [] components, ComponentBuilder.FormatRetention retention) {
        Preconditions.checkArgument((components.length != 0 ? 1 : 0) != 0, (Object)"No components to append");
        BaseComponent previous = this.current;
        for (BaseComponent component : components) {
            this.parts.add(this.current);
            this.current = component.duplicate();
            this.current.copyFormatting(previous, retention, false);
        }
        return this;
    }

    public InteractiveMessages append(String text) {
        return this.append(text, ComponentBuilder.FormatRetention.FORMATTING);
    }

    public InteractiveMessages append(String text, ComponentBuilder.FormatRetention retention) {
        this.parts.add(this.current);
        BaseComponent old = this.current;
        this.current = new TextComponent(new BaseComponent[]{TextComponent.fromLegacy((String)Utils.colorize(text))});
        this.current.copyFormatting(old, retention, false);
        return this;
    }

    public InteractiveMessages onClickRunCmd(String text) {
        return this.onClick(ClickEvent.Action.RUN_COMMAND, text);
    }

    public InteractiveMessages onClickSuggestCmd(String text) {
        return this.onClick(ClickEvent.Action.SUGGEST_COMMAND, text);
    }

    public InteractiveMessages onClick(ClickEvent.Action action, String text) {
        this.current.setClickEvent(new ClickEvent(action, Utils.colorize(text)));
        return this;
    }

    public InteractiveMessages onHover(String text) {
        return this.onHover(HoverEvent.Action.SHOW_TEXT, text);
    }

    public InteractiveMessages onHover(HoverEvent.Action action, String text) {
        this.current.setHoverEvent(new HoverEvent(action, new Content[]{new Text(TextComponent.fromLegacy((String)Utils.colorize(text)))}));
        return this;
    }

    public InteractiveMessages retain(ComponentBuilder.FormatRetention retention) {
        this.current.retain(retention);
        return this;
    }

    public BaseComponent @NotNull [] create() {
        BaseComponent[] result = this.parts.toArray(new BaseComponent[this.parts.size() + 1]);
        result[this.parts.size()] = this.current;
        return result;
    }

    public void send(Player ... players) {
        BaseComponent[] comp = this.create();
        for (Player player : players) {
            player.spigot().sendMessage(comp);
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    public static InteractiveMessages builder(String text) {
        return new InteractiveMessages(text);
    }
}

