/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs;

import com.itsschatten.libs.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class UpdateNotifications
extends BukkitRunnable {
    private static int projectId = 0;
    private static String latestVersion = "";

    public UpdateNotifications(int projectId) {
        UpdateNotifications.projectId = projectId;
    }

    public final boolean isUpdateAvailable() {
        String currentIdentifier;
        String currentVersion = Utils.getInstance().getDescription().getVersion();
        String string = currentIdentifier = currentVersion.contains("-") ? currentVersion.substring(currentVersion.indexOf("-")) : "";
        if (currentIdentifier.equalsIgnoreCase("dev")) {
            return false;
        }
        String[] latest = latestVersion.split("\\.");
        String[] current = currentVersion.split("\\.");
        int major = NumberUtils.toInt(latest[0]);
        int minor = NumberUtils.toInt(latest[1]);
        int patch = NumberUtils.toInt(latest[2]);
        int curMajor = NumberUtils.toInt(current[0]);
        int curMinor = NumberUtils.toInt(current[1]);
        int curPatch = NumberUtils.toInt(current[2]);
        if (curMajor > major) {
            return false;
        }
        if (major > curMajor) {
            return true;
        }
        if (minor > curMinor) {
            return true;
        }
        return patch > curPatch;
    }

    public final String getUpdateMessage() {
        return Utils.getUpdateAvailableMessage();
    }

    public void run() {
        try {
            URL url = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + projectId);
            URLConnection con = url.openConnection();
            try (BufferedReader r = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                latestVersion = r.readLine();
            }
            Utils.log("Checking for update...", new String[0]);
            if (this.isUpdateAvailable()) {
                this.onUpdateAvailable();
            }
        }
        catch (IOException ex) {
            Utils.logError(ex);
            Utils.logError("An error occurred while searching for an update! Are you offline?", new String[0]);
        }
    }

    public abstract void onUpdateAvailable();

    @Generated
    public static int getProjectId() {
        return projectId;
    }

    @Generated
    public static String getLatestVersion() {
        return latestVersion;
    }
}

