/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public final class Utils {
    private static final Pattern HEX_PATTERN = Pattern.compile("<#(\\w{6})>");
    private static final String[] VERSION = Bukkit.getServer().getBukkitVersion().split("-")[0].split("\\.");
    private static String prefix = "";
    private static JavaPlugin instance;
    private static String noPermsMessage;
    private static String updateAvailableMessage;
    private static boolean debugMode;

    @Contract(value="_ -> new")
    @NotNull
    public static NamespacedKey getKey(String key) {
        return new NamespacedKey((Plugin)Utils.getInstance(), key);
    }

    public static boolean isRunningMinecraft(int major, int minor) {
        return Utils.isRunningMinecraft(major, minor, 0);
    }

    public static boolean isRunningMinecraft(int major, int minor, int revision) {
        int rev;
        int maj = Integer.parseInt(VERSION[0]);
        int min = Integer.parseInt(VERSION[1]);
        try {
            rev = Integer.parseInt(VERSION[2]);
        }
        catch (Exception ignore) {
            rev = 0;
        }
        return maj >= major && min >= minor && rev >= revision;
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static void sendTitle(@NotNull Player pl, String title, String subtitle) {
        pl.sendTitle(Utils.colorize(title), Utils.colorize(subtitle), 20, 60, 10);
    }

    public static void sendBar(Player pl, String title) {
        try {
            pl.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Utils.colorize(title)));
        }
        catch (Throwable t) {
            Utils.tell((CommandSender)pl, title);
        }
    }

    public static void tell(CommandSender toWhom, String ... messages) {
        for (String message : messages) {
            Utils.tell(toWhom, message);
        }
    }

    public static void tell(CommandSender toWhom, @NotNull String message) {
        if (!message.isEmpty()) {
            toWhom.sendMessage(Utils.colorize(message.replace("{prefix}", Utils.getPrefix())));
        }
    }

    public static String colorize(@NotNull String message) {
        if (message.contains("<#")) {
            Matcher hexMatch = HEX_PATTERN.matcher(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            StringBuilder buffer = new StringBuilder();
            while (hexMatch.find()) {
                hexMatch.appendReplacement(buffer, ChatColor.of((String)("#" + hexMatch.group(1))).toString());
            }
            return hexMatch.appendTail(buffer).toString();
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static void registerCommand(Command command) {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            commandMap.register(instance.getName(), command);
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    public static <T> T getOrDefault(T nullable, T def) {
        return Objects.requireNonNullElse(nullable, def);
    }

    @NotNull
    public static Logger getLogger() {
        return Utils.getInstance().getLogger();
    }

    public static void log(@NotNull String message, String ... messages) {
        if (instance == null) {
            throw new NullPointerException("Cannot log messages with a null plugin instance.");
        }
        Utils.getLogger().info(message);
        if (!message.isEmpty()) {
            for (String msg : messages) {
                Utils.getLogger().info(msg);
            }
        }
    }

    public static void debugLog(@NotNull String message, String ... messages) {
        if (instance == null) {
            throw new NullPointerException("Cannot log messages with a null plugin instance.");
        }
        if (Utils.isDebugMode()) {
            Utils.getLogger().info("[DEBUG] " + message);
            if (!message.isEmpty()) {
                for (String msg : messages) {
                    Utils.getLogger().info("[DEBUG] " + msg);
                }
            }
        }
    }

    public static void logWarning(@NotNull String message, String ... messages) {
        if (instance == null) {
            throw new NullPointerException("Cannot log messages with a null plugin instance.");
        }
        Utils.getLogger().warning(message);
        if (!message.isEmpty()) {
            for (String msg : messages) {
                Utils.getLogger().warning(msg);
            }
        }
    }

    public static void logError(@NotNull String message, String ... messages) {
        if (instance == null) {
            throw new NullPointerException("Cannot log messages with a null plugin instance.");
        }
        Utils.getLogger().severe(message);
        if (!message.isEmpty()) {
            for (String msg : messages) {
                Utils.getLogger().severe(msg);
            }
        }
    }

    public static void logError(@NotNull Throwable error) {
        Utils.logError("---------------- [ ERROR LOG START ] ----------------", new String[0]);
        Utils.logError("ERROR TYPE: " + error, new String[0]);
        Utils.logError("CAUSE: " + (error.getCause() == null ? "N/A" : error.getCause().getMessage()), new String[0]);
        Utils.logError("MESSAGE: " + (error.getMessage() == null ? "" : error.getMessage()), new String[0]);
        for (StackTraceElement elm : error.getStackTrace()) {
            Utils.logError(elm.toString(), new String[0]);
        }
        Utils.logError("----------------- [ ERROR LOG END ] -----------------", new String[0]);
    }

    public static String serialize(ItemStack item) {
        return Utils.serializeArray(new ItemStack[]{item});
    }

    public static ItemStack deserialize(String data) {
        return Objects.requireNonNull(Utils.deserializeArray(data))[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String serializeArray(ItemStack[] item) {
        try {
            ByteArrayOutputStream finalOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream tempOutputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)tempOutputStream);
            int failedItems = 0;
            dataOutput.writeInt(item.length);
            for (ItemStack itemStack : item) {
                try {
                    dataOutput.writeObject((Object)itemStack);
                }
                catch (Exception ex) {
                    ++failedItems;
                    tempOutputStream.reset();
                }
                finally {
                    if (tempOutputStream.size() == 0) {
                        dataOutput.writeObject(null);
                    }
                    finalOutputStream.write(tempOutputStream.toByteArray());
                    tempOutputStream.reset();
                }
            }
            if (failedItems > 0) {
                Utils.logError("Failed to serialize " + failedItems + " invalid items", new String[0]);
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])finalOutputStream.toByteArray());
        }
        catch (EOFException ignored) {
            Utils.debugLog("EOF exception generated!", new String[0]);
        }
        catch (Exception ex) {
            Utils.logError(ex);
        }
        return null;
    }

    public static ItemStack @Nullable [] deserializeArray(String data) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack[] output = new ItemStack[dataInput.readInt()];
            for (int i = 0; i < output.length; ++i) {
                output[i] = (ItemStack)dataInput.readObject();
            }
            dataInput.close();
            return output;
        }
        catch (IOException | ClassNotFoundException e) {
            Utils.logError(e);
            return null;
        }
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static void setPrefix(String prefix) {
        Utils.prefix = prefix;
    }

    @Generated
    public static String getPrefix() {
        return prefix;
    }

    @Generated
    public static void setInstance(JavaPlugin instance) {
        Utils.instance = instance;
    }

    @Generated
    public static JavaPlugin getInstance() {
        return instance;
    }

    @Generated
    public static String getNoPermsMessage() {
        return noPermsMessage;
    }

    @Generated
    public static void setNoPermsMessage(String noPermsMessage) {
        Utils.noPermsMessage = noPermsMessage;
    }

    @Generated
    public static String getUpdateAvailableMessage() {
        return updateAvailableMessage;
    }

    @Generated
    public static void setUpdateAvailableMessage(String updateAvailableMessage) {
        Utils.updateAvailableMessage = updateAvailableMessage;
    }

    @Generated
    public static void setDebugMode(boolean debugMode) {
        Utils.debugMode = debugMode;
    }

    @Generated
    public static boolean isDebugMode() {
        return debugMode;
    }

    static {
        updateAvailableMessage = "";
    }
}

