/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.commandutils;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.interfaces.IPermissions;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class UniversalCommand
extends Command {
    private CommandSender sender;
    private String[] args;
    private String commandLabel;
    private String prefix = Utils.getPrefix();

    public UniversalCommand(String name) {
        super(name);
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        this.sender = sender;
        this.args = args;
        this.setPrefix(Utils.getPrefix());
        this.setCommandLabel(commandLabel.toLowerCase());
        try {
            this.run(sender, args);
        }
        catch (ReturnedCommandException ex) {
            String tellMessage = ex.tellMessage;
            this.tell(tellMessage);
        }
        return true;
    }

    protected abstract void run(CommandSender var1, String[] var2);

    protected int getNumber(int argsIndex, int from, int to, String errorMessage) {
        int number = 0;
        try {
            number = Integer.parseInt(this.args[argsIndex]);
            Validate.isTrue(number >= from && number <= to);
        }
        catch (IllegalArgumentException ex) {
            this.returnTell(errorMessage.replace("{min}", "" + from).replace("{max}", "" + to));
        }
        return number;
    }

    protected int getNumber(int argsIndex, String errorMessage) {
        int number = 0;
        try {
            number = Integer.parseInt(this.args[argsIndex]);
        }
        catch (IllegalArgumentException ex) {
            this.returnTell(errorMessage);
        }
        return number;
    }

    protected void checkNotNull(Object toCheck, String nullMessage) {
        if (toCheck == null) {
            this.returnTell(nullMessage);
        }
    }

    protected void checkArgs(int minLength, String message) {
        if (this.args.length < minLength) {
            this.returnTell(message);
        }
    }

    protected void checkArgsStrict(int requiredAmount, String message) {
        if (this.args.length != requiredAmount) {
            this.returnTell(message);
        }
    }

    protected void returnTell(String message) {
        throw new ReturnedCommandException(message);
    }

    protected void tell(String message) {
        Utils.tell(this.sender, message);
    }

    protected void tellTarget(Player target, String msg) {
        Utils.tell((CommandSender)target, msg);
    }

    protected void checkPerms(CommandSender sender, IPermissions perms) {
        if (!sender.hasPermission(perms.getPermission())) {
            this.returnTell(Utils.getNoPermsMessage().replace("{prefix}", this.prefix).replace("{permission}", perms.getPermission()));
        }
    }

    @Generated
    public String getCommandLabel() {
        return this.commandLabel;
    }

    @Generated
    private void setCommandLabel(String commandLabel) {
        this.commandLabel = commandLabel;
    }

    @Generated
    protected void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private final class ReturnedCommandException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String tellMessage;

        @Generated
        public ReturnedCommandException(String tellMessage) {
            this.tellMessage = tellMessage;
        }
    }
}

