/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.commandutils;

import com.itsschatten.libs.Utils;
import com.itsschatten.libs.interfaces.IPermissions;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class UserCommand
extends Command {
    private static String onlyPlayer = "&cI'm sorry only players can use this command.";
    private Player player;
    private String[] args;
    private String commandLabel;
    private String prefix = Utils.getPrefix();

    public UserCommand(String name) {
        super(name);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
        Player player;
        if (!(sender instanceof Player)) {
            this.tell(onlyPlayer);
            return true;
        }
        this.player = player = (Player)sender;
        this.setCommandLabel(commandLabel.toLowerCase());
        this.args = args;
        try {
            this.run(player, args);
        }
        catch (ReturnedCommandException ex) {
            String tellMessage = ex.tellMessage;
            this.tell(tellMessage);
        }
        return true;
    }

    protected abstract void run(Player var1, String[] var2);

    protected int getNumber(int argsIndex, int from, int to, String errorMessage) {
        int number = 0;
        try {
            number = Integer.parseInt(this.args[argsIndex]);
            Validate.isTrue(number >= from && number <= to);
        }
        catch (IllegalArgumentException ex) {
            this.returnTell(errorMessage.replace("{min}", "" + from).replace("{max}", "" + to));
        }
        return number;
    }

    protected int getNumber(int argsIndex, String errorMessage) {
        int number = 0;
        try {
            number = Integer.parseInt(this.args[argsIndex]);
        }
        catch (IllegalArgumentException ex) {
            this.returnTell(errorMessage);
        }
        return number;
    }

    protected void checkNotNull(Object toCheck, String nullMessage) {
        if (toCheck == null) {
            this.returnTell(nullMessage);
        }
    }

    protected void checkArgs(int minLength, String message) {
        if (this.args.length < minLength) {
            this.returnTell(message);
        }
    }

    protected void checkArgsStrict(int requiredAmount, String message) {
        if (this.args.length != requiredAmount) {
            this.returnTell(message);
        }
    }

    protected void returnTell(String message) {
        throw new ReturnedCommandException(message);
    }

    protected void tell(String message) {
        Utils.tell((CommandSender)this.player, message);
    }

    protected void tellTarget(Player target, String msg) {
        Utils.tell((CommandSender)target, msg);
    }

    protected void checkPerms(@NotNull Player player, @NotNull IPermissions perms) {
        if (!player.hasPermission(perms.getPermission())) {
            this.returnTell(Utils.getNoPermsMessage().replace("{prefix}", this.prefix).replace("{permission}", perms.getPermission()));
        }
    }

    @Generated
    public static void setOnlyPlayer(String onlyPlayer) {
        UserCommand.onlyPlayer = onlyPlayer;
    }

    @Generated
    public String getCommandLabel() {
        return this.commandLabel;
    }

    @Generated
    private void setCommandLabel(String commandLabel) {
        this.commandLabel = commandLabel;
    }

    @Generated
    protected void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private static final class ReturnedCommandException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String tellMessage;

        @Generated
        public ReturnedCommandException(String tellMessage) {
            this.tellMessage = tellMessage;
        }
    }
}

