/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.configutils;

import com.itsschatten.libs.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PlayerConfigManager {
    private static final List<PlayerConfigManager> configs = new ArrayList<PlayerConfigManager>();
    private final UUID u;
    private final String path;
    private final JavaPlugin plugin = JavaPlugin.getProvidingPlugin(this.getClass());
    private FileConfiguration fc;
    private File file;

    private PlayerConfigManager(@NotNull Player p) {
        this.u = p.getUniqueId();
        this.path = null;
        configs.add(this);
    }

    private PlayerConfigManager(@NotNull Player p, String path) {
        this.u = p.getUniqueId();
        this.path = path;
        configs.add(this);
    }

    private PlayerConfigManager(UUID u, String path) {
        this.u = u;
        this.path = path;
        configs.add(this);
    }

    private PlayerConfigManager(UUID u) {
        this.u = u;
        this.path = null;
        configs.add(this);
    }

    @NotNull
    public static PlayerConfigManager getConfig(Player p) {
        for (PlayerConfigManager c : configs) {
            if (!c.getOwnerUUID().equals(p.getUniqueId())) continue;
            return c;
        }
        return new PlayerConfigManager(p);
    }

    @NotNull
    public static PlayerConfigManager getConfig(Player p, String path) {
        for (PlayerConfigManager c : configs) {
            if (!c.getOwnerUUID().equals(p.getUniqueId())) continue;
            return c;
        }
        return new PlayerConfigManager(p, path);
    }

    @NotNull
    public static PlayerConfigManager getConfig(UUID u) {
        for (PlayerConfigManager c : configs) {
            if (!c.getOwnerUUID().equals(u)) continue;
            return c;
        }
        return new PlayerConfigManager(u);
    }

    public static void removeConfig(@NotNull Player player) {
        PlayerConfigManager.removeConfig(player.getUniqueId());
    }

    public static void removeConfig(UUID uuid) {
        PlayerConfigManager config = null;
        for (PlayerConfigManager c : configs) {
            if (!c.getOwnerUUID().equals(uuid)) continue;
            config = c;
            break;
        }
        if (config != null) {
            config.discard();
        }
    }

    public Player getOwner() {
        if (this.u == null) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                this.getInstance().getLogger().warning("ERR... Player is Null!");
                Utils.logError(e);
                return null;
            }
        }
        return Bukkit.getPlayer((UUID)this.u);
    }

    public UUID getOwnerUUID() {
        if (this.u == null) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                this.getInstance().getLogger().warning("ERR... Player is Null!");
                Utils.logError(e);
                return null;
            }
        }
        return this.u;
    }

    public final void discard() {
        configs.remove(this);
    }

    public JavaPlugin getInstance() {
        return this.plugin;
    }

    public boolean delete() {
        return this.getFile().delete();
    }

    public boolean exists() {
        if (this.fc == null || this.file == null) {
            File temp = this.path != null ? new File(this.path, this.getOwnerUUID() + ".yml") : new File(this.getDataFolder(), this.getOwnerUUID() + ".yml");
            if (!temp.exists()) {
                return false;
            }
            this.file = temp;
        }
        return true;
    }

    public File getDataFolder() {
        File dir = new File(PlayerConfigManager.class.getProtectionDomain().getCodeSource().getLocation().getPath().replaceAll("%20", " "));
        File d = new File(dir.getParentFile().getPath(), this.getInstance().getName() + File.separator + "data");
        if (!d.exists()) {
            d.mkdirs();
        }
        return d;
    }

    public File getFile() {
        if (this.file == null) {
            this.file = this.path != null ? new File(this.path, this.getOwnerUUID() + ".yml") : new File(this.getDataFolder(), this.getOwnerUUID() + ".yml");
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    Utils.logError(e);
                }
            }
        }
        return this.file;
    }

    public FileConfiguration getConfig() {
        if (this.fc == null) {
            this.fc = YamlConfiguration.loadConfiguration((File)this.getFile());
        }
        return this.fc;
    }

    public void reload() {
        if (this.file == null) {
            this.file = this.path != null ? new File(this.path, this.getOwnerUUID() + ".yml") : new File(this.getDataFolder(), this.getOwnerUUID() + ".yml");
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    Utils.logError(e);
                }
            }
            this.fc = YamlConfiguration.loadConfiguration((File)this.file);
            Utils.log("Player Config for player " + this.getOwner().getDisplayName() + " has been 'reloaded'", new String[0]);
        }
    }

    public void resetConfig() {
        this.delete();
        this.getConfig();
    }

    public void saveConfig() {
        try {
            this.getConfig().save(this.getFile());
        }
        catch (IOException e) {
            Utils.logError(e);
        }
    }

    @Generated
    public static List<PlayerConfigManager> getConfigs() {
        return configs;
    }
}

