/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.configutils;

import com.itsschatten.libs.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SimpleConfig
extends YamlConfiguration {
    private final File file;
    private final YamlConfiguration defaults;
    private String[] editHeader;
    private String pathPrefix;

    public SimpleConfig(String fileName) {
        this(fileName, true);
    }

    public SimpleConfig(String fileName, boolean useDefaults) {
        if (useDefaults) {
            this.defaults = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(SimpleConfig.class.getResourceAsStream("/" + fileName), StandardCharsets.UTF_8));
            Objects.requireNonNull(this.defaults, "Could not get the default " + fileName + " inside of your plugin, make sure you created the file and that you did not replace the jar on a running server!");
        } else {
            this.defaults = null;
        }
        this.file = this.extract(fileName);
        this.loadConfig();
    }

    public void setHeader(String[] editHeader) {
        this.editHeader = editHeader;
    }

    public void reloadConfig() {
        this.saveConfig();
        this.loadConfig();
    }

    public void write(String path, Object value) {
        this.set(path, value);
        this.reloadConfig();
    }

    public void saveConfig() {
        try {
            if (this.editHeader != null) {
                this.options().setHeader(Collections.singletonList(StringUtils.join((Object[])this.editHeader, System.lineSeparator())));
                this.options().copyHeader(true);
            }
            super.save(this.file);
        }
        catch (IOException ex) {
            Utils.logError(ex);
            Utils.logError("Failed to save configuration from '" + this.file + "'.", new String[0]);
        }
    }

    private void loadConfig() {
        try {
            super.load(this.file);
        }
        catch (Throwable t) {
            Utils.logError(t);
            Utils.logError("Failed to load configuration from " + this.file, new String[0]);
        }
    }

    public Object get(@NotNull String path, Object def) {
        if (this.defaults != null) {
            if (def != null && !def.getClass().isPrimitive() && !PrimitiveWrapper.isWrapperType(def.getClass())) {
                throw new IllegalArgumentException("The default value must be null since we use defaults from file inside of the plugin! Path: " + (String)path + ", default called: " + def);
            }
            if (super.get((String)path, null) == null) {
                Object defaultValue = this.defaults.get((String)path);
                Objects.requireNonNull(defaultValue, "Default " + this.file.getName() + " in your .jar lacks a key at '" + (String)path + "' path");
                Utils.log("Updating " + this.file.getName() + ". Set '" + (String)path + "' to '" + defaultValue + "'", new String[0]);
                this.write((String)path, defaultValue);
            }
        }
        String m = new Throwable().getStackTrace()[1].getMethodName();
        if (this.defaults == null && this.pathPrefix != null && !m.equals("getConfigurationSection") && !m.equals("get")) {
            path = this.pathPrefix + "." + (String)path;
        }
        return super.get((String)path, null);
    }

    public void set(@NotNull String path, Object value) {
        String m = new Throwable().getStackTrace()[1].getMethodName();
        if (this.defaults == null && this.pathPrefix != null && !m.equals("getConfigurationSection") && !m.equals("get")) {
            path = this.pathPrefix + "." + (String)path;
        }
        super.set((String)path, value);
    }

    @NotNull
    private File extract(String path) {
        JavaPlugin i = Utils.getInstance();
        File file = new File(i.getDataFolder(), path);
        if (file.exists()) {
            return file;
        }
        this.createFileAndDirectory(path);
        if (this.defaults != null) {
            try (InputStream is = i.getResource(path);){
                Objects.requireNonNull(is, "Inbuilt file not found: " + path);
                Files.copy(is, Paths.get(file.toURI()), StandardCopyOption.REPLACE_EXISTING);
                Utils.log("Created the default file '" + path + "'.", new String[0]);
            }
            catch (IOException e) {
                Utils.logError(e);
            }
        }
        return file;
    }

    @NotNull
    private File createFileAndDirectory(@NotNull String path) {
        File dataFolder = Utils.getInstance().getDataFolder();
        int lastIndex = path.lastIndexOf(47);
        File directory = new File(dataFolder, path.substring(0, Math.max(lastIndex, 0)));
        directory.mkdirs();
        File destination = new File(dataFolder, path);
        try {
            if (!destination.createNewFile()) {
                Utils.logError("Failed to create the '" + destination + "' file...", new String[0]);
            }
        }
        catch (IOException ex) {
            Utils.logError(ex);
            Utils.logError("Failed to create file '" + path + "'.", new String[0]);
        }
        return destination;
    }

    @Generated
    public String[] getEditHeader() {
        return this.editHeader;
    }

    @Generated
    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    private static final class PrimitiveWrapper {
        private static final Set<Class<?>> WRAPPER_TYPES = PrimitiveWrapper.getWrapperTypes();

        private PrimitiveWrapper() {
        }

        private static boolean isWrapperType(Class<?> clazz) {
            return WRAPPER_TYPES.contains(clazz);
        }

        @NotNull
        private static Set<Class<?>> getWrapperTypes() {
            HashSet ret = new HashSet();
            ret.add(Boolean.class);
            ret.add(Character.class);
            ret.add(Byte.class);
            ret.add(Short.class);
            ret.add(Integer.class);
            ret.add(Long.class);
            ret.add(Float.class);
            ret.add(Double.class);
            ret.add(Void.class);
            return ret;
        }
    }
}

