/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mariadb.client.column;

import com.itsschatten.libs.drivers.mariadb.Configuration;
import com.itsschatten.libs.drivers.mariadb.client.ColumnDecoder;
import com.itsschatten.libs.drivers.mariadb.client.DataType;
import com.itsschatten.libs.drivers.mariadb.client.ReadableByteBuf;
import com.itsschatten.libs.drivers.mariadb.client.util.MutableInt;
import com.itsschatten.libs.drivers.mariadb.message.server.ColumnDefinitionPacket;
import com.itsschatten.libs.drivers.mariadb.plugin.codec.LocalTimeCodec;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TimeColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public TimeColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat, false);
    }

    protected TimeColumn(TimeColumn prev) {
        super(prev, true);
    }

    @Override
    public TimeColumn useAliasAsName() {
        return new TimeColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return Time.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return 92;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return "TIME";
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        Calendar c = Calendar.getInstance();
        int offset = c.getTimeZone().getOffset(0L);
        int[] parts = LocalTimeCodec.parseTime(buf, length, this);
        long timeInMillis = ((long)parts[1] * 3600000L + (long)parts[2] * 60000L + (long)parts[3] * 1000L + (long)(parts[4] / 1000000)) * (long)parts[0] - (long)offset;
        return new Time(timeInMillis);
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        boolean negate = false;
        Calendar cal = Calendar.getInstance();
        long dayOfMonth = 0L;
        int hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        if (length.get() > 0) {
            negate = buf.readByte() == 1;
            dayOfMonth = buf.readUnsignedInt();
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length.get() > 8) {
                microseconds = buf.readUnsignedInt();
            }
        }
        int offset = cal.getTimeZone().getOffset(0L);
        long timeInMillis = ((24L * dayOfMonth + (long)hour) * 3600000L + (long)(minutes * 60000) + (long)(seconds * 1000) + microseconds / 1000L) * (long)(negate ? -1 : 1) - (long)offset;
        return new Time(timeInMillis);
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return buf.readString(length.get());
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        boolean negate;
        long tDays = 0L;
        int tHours = 0;
        byte tMinutes = 0;
        byte tSeconds = 0;
        long tMicroseconds = 0L;
        if (length.get() == 0) {
            StringBuilder zeroValue = new StringBuilder("00:00:00");
            if (this.getDecimals() > 0) {
                zeroValue.append(".");
                for (int i = 0; i < this.getDecimals(); ++i) {
                    zeroValue.append("0");
                }
            }
            return zeroValue.toString();
        }
        boolean bl = negate = buf.readByte() == 1;
        if (length.get() > 4) {
            tDays = buf.readUnsignedInt();
            if (length.get() > 7) {
                tHours = buf.readByte();
                tMinutes = buf.readByte();
                tSeconds = buf.readByte();
                if (length.get() > 8) {
                    tMicroseconds = buf.readInt();
                }
            }
        }
        int totalHour = (int)(tDays * 24L + (long)tHours);
        String stTime = (negate ? "-" : "") + (totalHour < 10 ? "0" : "") + totalHour + ":" + (tMinutes < 10 ? "0" : "") + tMinutes + ":" + (tSeconds < 10 ? "0" : "") + tSeconds;
        if (this.getDecimals() == 0) {
            if (tMicroseconds == 0L) {
                return stTime;
            }
            StringBuilder stMicro = new StringBuilder(String.valueOf(tMicroseconds));
            while (stMicro.length() < 6) {
                stMicro.insert(0, "0");
            }
            return stTime + "." + stMicro;
        }
        StringBuilder stMicro = new StringBuilder(String.valueOf(tMicroseconds));
        while (stMicro.length() < this.getDecimals()) {
            stMicro.insert(0, "0");
        }
        return stTime + "." + stMicro;
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        Calendar c = cal == null ? Calendar.getInstance() : cal;
        int offset = c.getTimeZone().getOffset(0L);
        int[] parts = LocalTimeCodec.parseTime(buf, length, this);
        long timeInMillis = ((long)parts[1] * 3600000L + (long)parts[2] * 60000L + (long)parts[3] * 1000L + (long)(parts[4] / 1000000)) * (long)parts[0] - (long)offset;
        return new Time(timeInMillis);
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        long dayOfMonth = 0L;
        int hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        boolean negate = false;
        if (length.get() > 0) {
            negate = buf.readByte() == 1;
            dayOfMonth = buf.readUnsignedInt();
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length.get() > 8) {
                microseconds = buf.readUnsignedInt();
            }
        }
        int offset = cal.getTimeZone().getOffset(0L);
        long timeInMillis = ((24L * dayOfMonth + (long)hour) * 3600000L + (long)(minutes * 60000) + (long)(seconds * 1000) + microseconds / 1000L) * (long)(negate ? -1 : 1) - (long)offset;
        return new Time(timeInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        Timestamp t;
        int[] parts = LocalTimeCodec.parseTime(buf, length, this);
        if (calParam == null) {
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.setLenient(true);
            if (parts[0] == -1) {
                cal.set(1970, 0, 1, parts[0] * parts[1], parts[0] * parts[2], parts[0] * parts[3] - 1);
                t = new Timestamp(cal.getTimeInMillis());
                t.setNanos(1000000000 - parts[4]);
            } else {
                cal.set(1970, 0, 1, parts[1], parts[2], parts[3]);
                t = new Timestamp(cal.getTimeInMillis());
                t.setNanos(parts[4]);
            }
        } else {
            Calendar calendar = calParam;
            synchronized (calendar) {
                calParam.clear();
                calParam.setLenient(true);
                if (parts[0] == -1) {
                    calParam.set(1970, 0, 1, parts[0] * parts[1], parts[0] * parts[2], parts[0] * parts[3] - 1);
                    t = new Timestamp(calParam.getTimeInMillis());
                    t.setNanos(1000000000 - parts[4]);
                } else {
                    calParam.set(1970, 0, 1, parts[1], parts[2], parts[3]);
                    t = new Timestamp(calParam.getTimeInMillis());
                    t.setNanos(parts[4]);
                }
            }
        }
        return t;
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        long microseconds = 0L;
        boolean negate = buf.readByte() == 1;
        long dayOfMonth = buf.readUnsignedInt();
        byte hour = buf.readByte();
        byte minutes = buf.readByte();
        byte seconds = buf.readByte();
        if (length.get() > 8) {
            microseconds = buf.readUnsignedInt();
        }
        int offset = cal.getTimeZone().getOffset(0L);
        long timeInMillis = ((24L * dayOfMonth + (long)hour) * 3600000L + (long)(minutes * 60000) + (long)(seconds * 1000) + microseconds / 1000L) * (long)(negate ? -1 : 1) - (long)offset;
        return new Timestamp(timeInMillis);
    }
}

