/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mariadb.client.context;

import com.itsschatten.libs.drivers.mariadb.Configuration;
import com.itsschatten.libs.drivers.mariadb.HostAddress;
import com.itsschatten.libs.drivers.mariadb.client.PrepareCache;
import com.itsschatten.libs.drivers.mariadb.client.context.BaseContext;
import com.itsschatten.libs.drivers.mariadb.client.impl.TransactionSaver;
import com.itsschatten.libs.drivers.mariadb.export.ExceptionFactory;
import com.itsschatten.libs.drivers.mariadb.message.ClientMessage;
import com.itsschatten.libs.drivers.mariadb.message.client.RedoableClientMessage;
import com.itsschatten.libs.drivers.mariadb.message.server.InitialHandshakePacket;

public class RedoContext
extends BaseContext {
    private final TransactionSaver transactionSaver;

    public RedoContext(HostAddress hostAddress, InitialHandshakePacket handshake, long clientCapabilities, Configuration conf, ExceptionFactory exceptionFactory, PrepareCache prepareCache) {
        super(hostAddress, handshake, clientCapabilities, conf, exceptionFactory, prepareCache);
        this.transactionSaver = new TransactionSaver(conf.transactionReplaySize());
    }

    @Override
    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
        if ((serverStatus & 1) == 0) {
            this.transactionSaver.clear();
        }
    }

    public void saveRedo(ClientMessage msg) {
        if (msg instanceof RedoableClientMessage) {
            RedoableClientMessage redoMsg = (RedoableClientMessage)msg;
            redoMsg.saveParameters();
            this.transactionSaver.add(redoMsg);
        }
    }

    public void saveRedo(ClientMessage[] msgs) {
        for (ClientMessage msg : msgs) {
            this.saveRedo(msg);
        }
    }

    public TransactionSaver getTransactionSaver() {
        return this.transactionSaver;
    }
}

