/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mariadb.client.impl;

import com.itsschatten.libs.drivers.mariadb.Configuration;
import com.itsschatten.libs.drivers.mariadb.HostAddress;
import com.itsschatten.libs.drivers.mariadb.client.Context;
import com.itsschatten.libs.drivers.mariadb.client.ReadableByteBuf;
import com.itsschatten.libs.drivers.mariadb.client.SocketHelper;
import com.itsschatten.libs.drivers.mariadb.client.socket.Reader;
import com.itsschatten.libs.drivers.mariadb.client.socket.Writer;
import com.itsschatten.libs.drivers.mariadb.client.socket.impl.SocketHandlerFunction;
import com.itsschatten.libs.drivers.mariadb.client.socket.impl.SocketUtility;
import com.itsschatten.libs.drivers.mariadb.export.SslMode;
import com.itsschatten.libs.drivers.mariadb.message.client.SslRequestPacket;
import com.itsschatten.libs.drivers.mariadb.message.server.AuthSwitchPacket;
import com.itsschatten.libs.drivers.mariadb.message.server.ErrorPacket;
import com.itsschatten.libs.drivers.mariadb.message.server.OkPacket;
import com.itsschatten.libs.drivers.mariadb.plugin.AuthenticationPlugin;
import com.itsschatten.libs.drivers.mariadb.plugin.Credential;
import com.itsschatten.libs.drivers.mariadb.plugin.CredentialPlugin;
import com.itsschatten.libs.drivers.mariadb.plugin.TlsSocketPlugin;
import com.itsschatten.libs.drivers.mariadb.plugin.authentication.AuthenticationPluginLoader;
import com.itsschatten.libs.drivers.mariadb.plugin.tls.TlsSocketPluginLoader;
import com.itsschatten.libs.drivers.mariadb.util.ConfigurableSocketFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Arrays;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class ConnectionHelper {
    private static final SocketHandlerFunction socketHandler;

    public static Socket createSocket(Configuration conf, HostAddress hostAddress) throws IOException, SQLException {
        return socketHandler.apply(conf, hostAddress);
    }

    public static Socket standardSocket(Configuration conf, HostAddress hostAddress) throws IOException, SQLException {
        String socketFactoryName = conf.socketFactory();
        if (socketFactoryName != null) {
            if (hostAddress == null) {
                throw new SQLException("hostname must be set to connect socket");
            }
            try {
                Class<?> socketFactoryClass = Class.forName(socketFactoryName, false, ConnectionHelper.class.getClassLoader());
                if (!SocketFactory.class.isAssignableFrom(socketFactoryClass)) {
                    throw new IOException("Wrong Socket factory implementation '" + conf.socketFactory() + "'");
                }
                Constructor<?> constructor = socketFactoryClass.getConstructor(new Class[0]);
                SocketFactory socketFactory = (SocketFactory)constructor.newInstance(new Object[0]);
                if (socketFactory instanceof ConfigurableSocketFactory) {
                    ((ConfigurableSocketFactory)socketFactory).setConfiguration(conf, hostAddress.host);
                }
                return socketFactory.createSocket();
            }
            catch (Exception exp) {
                throw new IOException("Socket factory failed to initialized with option \"socketFactory\" set to \"" + conf.socketFactory() + "\"", exp);
            }
        }
        SocketFactory socketFactory = SocketFactory.getDefault();
        return socketFactory.createSocket();
    }

    public static Socket connectSocket(Configuration conf, HostAddress hostAddress) throws SQLException {
        try {
            if (conf.pipe() == null && conf.localSocket() == null && hostAddress == null) {
                throw new SQLException("hostname must be set to connect socket if not using local socket or pipe");
            }
            Socket socket = ConnectionHelper.createSocket(conf, hostAddress);
            SocketHelper.setSocketOption(conf, socket);
            if (!socket.isConnected()) {
                InetSocketAddress sockAddr = conf.pipe() == null && conf.localSocket() == null ? new InetSocketAddress(hostAddress.host, hostAddress.port) : null;
                socket.connect(sockAddr, conf.connectTimeout());
            }
            return socket;
        }
        catch (IOException ioe) {
            throw new SQLNonTransientConnectionException(String.format("Socket fail to connect to host:%s. %s", hostAddress == null ? conf.localSocket() : hostAddress, ioe.getMessage()), "08000", ioe);
        }
    }

    public static long initializeClientCapabilities(Configuration configuration, long serverCapabilities, HostAddress hostAddress) {
        boolean deprecateEof;
        boolean extendedTypeInfo;
        long capabilities = 12493568L;
        if (configuration.useServerPrepStmts() && Boolean.parseBoolean(configuration.nonMappedOptions().getProperty("enableSkipMeta", "true"))) {
            capabilities |= 0x1000000000L;
        }
        if (Boolean.parseBoolean(configuration.nonMappedOptions().getProperty("interactiveClient", "false"))) {
            capabilities |= 0x400L;
        }
        if (configuration.useBulkStmts() || configuration.useBulkStmtsForInserts()) {
            capabilities |= 0x400000000L;
        }
        if (!configuration.useAffectedRows()) {
            capabilities |= 2L;
        }
        if (configuration.allowMultiQueries()) {
            capabilities |= 0x10000L;
        }
        if (configuration.allowLocalInfile()) {
            capabilities |= 0x80L;
        }
        if (extendedTypeInfo = Boolean.parseBoolean(configuration.nonMappedOptions().getProperty("extendedTypeInfo", "true"))) {
            capabilities |= 0x800000000L;
        }
        if (deprecateEof = Boolean.parseBoolean(configuration.nonMappedOptions().getProperty("deprecateEof", "true"))) {
            capabilities |= 0x1000000L;
        }
        if (configuration.useCompression()) {
            capabilities |= 0x20L;
        }
        if (configuration.database() != null && (!configuration.createDatabaseIfNotExist() || configuration.createDatabaseIfNotExist() && hostAddress != null && !hostAddress.primary.booleanValue())) {
            capabilities |= 8L;
        }
        if (configuration.sslMode() != SslMode.DISABLE) {
            capabilities |= 0x800L;
        }
        return capabilities & serverCapabilities;
    }

    public static void authenticationHandler(Credential credential, Writer writer, Reader reader, Context context) throws IOException, SQLException {
        writer.permitTrace(true);
        Configuration conf = context.getConf();
        ReadableByteBuf buf = reader.readReusablePacket();
        block5: while (true) {
            switch (buf.getByte() & 0xFF) {
                case 254: {
                    AuthSwitchPacket authSwitchPacket = AuthSwitchPacket.decode(buf);
                    AuthenticationPlugin authenticationPlugin = AuthenticationPluginLoader.get(authSwitchPacket.getPlugin(), conf);
                    authenticationPlugin.initialize(credential.getPassword(), authSwitchPacket.getSeed(), conf);
                    buf = authenticationPlugin.process(writer, reader, context);
                    continue block5;
                }
                case 255: {
                    ErrorPacket errorPacket = new ErrorPacket(buf, context);
                    throw context.getExceptionFactory().create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
                }
                case 0: {
                    new OkPacket(buf, context);
                    break block5;
                }
                default: {
                    throw context.getExceptionFactory().create("unexpected data during authentication (header=" + buf.getUnsignedByte(), "08000");
                }
            }
            break;
        }
        writer.permitTrace(true);
    }

    public static Credential loadCredential(CredentialPlugin credentialPlugin, Configuration configuration, HostAddress hostAddress) throws SQLException {
        if (credentialPlugin != null) {
            return (Credential)credentialPlugin.initialize(configuration, configuration.user(), hostAddress).get();
        }
        return new Credential(configuration.user(), configuration.password());
    }

    public static SSLSocket sslWrapper(HostAddress hostAddress, Socket socket, long clientCapabilities, byte exchangeCharset, Context context, Writer writer) throws IOException, SQLException {
        Configuration conf = context.getConf();
        if (conf.sslMode() != SslMode.DISABLE) {
            if (!context.hasServerCapability(2048L)) {
                throw context.getExceptionFactory().create("Trying to connect with ssl, but ssl not enabled in the server", "08000");
            }
            SslRequestPacket.create(clientCapabilities |= 0x800L, exchangeCharset).encode(writer, context);
            TlsSocketPlugin socketPlugin = TlsSocketPluginLoader.get(conf.tlsSocketType());
            SSLSocketFactory sslSocketFactory = socketPlugin.getSocketFactory(conf, context.getExceptionFactory());
            SSLSocket sslSocket = socketPlugin.createSocket(socket, sslSocketFactory);
            ConnectionHelper.enabledSslProtocolSuites(sslSocket, conf);
            ConnectionHelper.enabledSslCipherSuites(sslSocket, conf);
            sslSocket.setUseClientMode(true);
            sslSocket.startHandshake();
            if (conf.sslMode() == SslMode.VERIFY_FULL && hostAddress != null) {
                SSLSession session = sslSocket.getSession();
                try {
                    socketPlugin.verify(hostAddress.host, session, context.getThreadId());
                }
                catch (SSLException ex) {
                    throw context.getExceptionFactory().create("SSL hostname verification failed : " + ex.getMessage() + "\nThis verification can be disabled using the sslMode to VERIFY_CA but won't prevent man-in-the-middle attacks anymore", "08006");
                }
            }
            return sslSocket;
        }
        return null;
    }

    static void enabledSslProtocolSuites(SSLSocket sslSocket, Configuration conf) throws SQLException {
        if (conf.enabledSslProtocolSuites() != null) {
            String[] protocols;
            List<String> possibleProtocols = Arrays.asList(sslSocket.getSupportedProtocols());
            for (String protocol : protocols = conf.enabledSslProtocolSuites().split("[,;\\s]+")) {
                if (possibleProtocols.contains(protocol)) continue;
                throw new SQLException("Unsupported SSL protocol '" + protocol + "'. Supported protocols : " + possibleProtocols.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledProtocols(protocols);
        }
    }

    static void enabledSslCipherSuites(SSLSocket sslSocket, Configuration conf) throws SQLException {
        if (conf.enabledSslCipherSuites() != null) {
            String[] ciphers;
            List<String> possibleCiphers = Arrays.asList(sslSocket.getSupportedCipherSuites());
            for (String cipher : ciphers = conf.enabledSslCipherSuites().split("[,;\\s]+")) {
                if (possibleCiphers.contains(cipher)) continue;
                throw new SQLException("Unsupported SSL cipher '" + cipher + "'. Supported ciphers : " + possibleCiphers.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledCipherSuites(ciphers);
        }
    }

    static {
        SocketHandlerFunction init;
        try {
            init = SocketUtility.getSocketHandler();
        }
        catch (Throwable t) {
            init = ConnectionHelper::standardSocket;
        }
        socketHandler = init;
    }
}

