/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mariadb.client.impl;

import com.itsschatten.libs.drivers.mariadb.ServerPreparedStatement;
import com.itsschatten.libs.drivers.mariadb.client.impl.StandardClient;
import com.itsschatten.libs.drivers.mariadb.export.Prepare;
import com.itsschatten.libs.drivers.mariadb.message.server.CachedPrepareResultPacket;
import com.itsschatten.libs.drivers.mariadb.message.server.PrepareResultPacket;
import java.util.LinkedHashMap;
import java.util.Map;

public final class PrepareCache
extends LinkedHashMap<String, CachedPrepareResultPacket>
implements com.itsschatten.libs.drivers.mariadb.client.PrepareCache {
    private static final long serialVersionUID = -8922905563713952695L;
    private final int maxSize;
    private final transient StandardClient con;

    public PrepareCache(int size, StandardClient con) {
        super(size, 0.75f, true);
        this.maxSize = size;
        this.con = con;
    }

    @Override
    public boolean removeEldestEntry(Map.Entry<String, CachedPrepareResultPacket> eldest) {
        if (this.size() > this.maxSize) {
            eldest.getValue().unCache(this.con);
            return true;
        }
        return false;
    }

    @Override
    public synchronized Prepare get(String key, ServerPreparedStatement preparedStatement) {
        CachedPrepareResultPacket prepare = (CachedPrepareResultPacket)super.get(key);
        if (prepare != null && preparedStatement != null) {
            prepare.incrementUse(preparedStatement);
        }
        return prepare;
    }

    @Override
    public synchronized Prepare put(String key, Prepare result, ServerPreparedStatement preparedStatement) {
        CachedPrepareResultPacket cached = (CachedPrepareResultPacket)super.get(key);
        if (cached != null) {
            cached.incrementUse(preparedStatement);
            ((CachedPrepareResultPacket)result).unCache(this.con);
            return cached;
        }
        if (((CachedPrepareResultPacket)result).cache()) {
            ((CachedPrepareResultPacket)result).incrementUse(preparedStatement);
            super.put(key, (CachedPrepareResultPacket)result);
        }
        return null;
    }

    @Override
    public CachedPrepareResultPacket get(Object key) {
        throw new IllegalStateException("not available method");
    }

    @Override
    public CachedPrepareResultPacket put(String key, PrepareResultPacket result) {
        throw new IllegalStateException("not available method");
    }

    @Override
    public void reset() {
        for (CachedPrepareResultPacket prep : this.values()) {
            prep.reset();
        }
        this.clear();
    }
}

