/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mariadb.client.impl;

import com.itsschatten.libs.drivers.mariadb.Configuration;
import com.itsschatten.libs.drivers.mariadb.HostAddress;
import com.itsschatten.libs.drivers.mariadb.Statement;
import com.itsschatten.libs.drivers.mariadb.client.Completion;
import com.itsschatten.libs.drivers.mariadb.client.context.RedoContext;
import com.itsschatten.libs.drivers.mariadb.client.impl.StandardClient;
import com.itsschatten.libs.drivers.mariadb.client.impl.TransactionSaver;
import com.itsschatten.libs.drivers.mariadb.export.MaxAllowedPacketException;
import com.itsschatten.libs.drivers.mariadb.export.Prepare;
import com.itsschatten.libs.drivers.mariadb.message.ClientMessage;
import com.itsschatten.libs.drivers.mariadb.message.client.PreparePacket;
import com.itsschatten.libs.drivers.mariadb.message.client.RedoableClientMessage;
import com.itsschatten.libs.drivers.mariadb.message.client.RedoableWithPrepareClientMessage;
import com.itsschatten.libs.drivers.mariadb.message.server.PrepareResultPacket;
import com.itsschatten.libs.drivers.mariadb.util.log.Logger;
import com.itsschatten.libs.drivers.mariadb.util.log.Loggers;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class ReplayClient
extends StandardClient {
    private static final Logger logger = Loggers.getLogger(ReplayClient.class);

    public ReplayClient(Configuration conf, HostAddress hostAddress, ReentrantLock lock, boolean skipPostCommands) throws SQLException {
        super(conf, hostAddress, lock, skipPostCommands);
    }

    @Override
    public int sendQuery(ClientMessage message) throws SQLException {
        this.checkNotClosed();
        try {
            if (message instanceof RedoableClientMessage) {
                ((RedoableClientMessage)message).ensureReplayable(this.context);
            }
            return message.encode(this.writer, this.context);
        }
        catch (IOException ioException) {
            if (ioException instanceof MaxAllowedPacketException) {
                if (((MaxAllowedPacketException)ioException).isMustReconnect()) {
                    this.destroySocket();
                    throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "08000", ioException);
                }
                throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "HZ000", ioException);
            }
            this.destroySocket();
            throw this.exceptionFactory.withSql(message.description()).create("Socket error", "08000", ioException);
        }
    }

    @Override
    public List<Completion> executePipeline(ClientMessage[] messages, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        List<Completion> res = super.executePipeline(messages, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        ((RedoContext)this.context).saveRedo(messages);
        return res;
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        List<Completion> completions = super.execute(message, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        ((RedoContext)this.context).saveRedo(message);
        return completions;
    }

    public void transactionReplay(TransactionSaver transactionSaver) throws SQLException {
        RedoableClientMessage[] buffers = transactionSaver.getBuffers();
        try {
            for (int i = 0; i < transactionSaver.getIdx(); ++i) {
                int responseNo;
                RedoableClientMessage querySaver = buffers[i];
                if (querySaver instanceof RedoableWithPrepareClientMessage) {
                    RedoableWithPrepareClientMessage redoable = (RedoableWithPrepareClientMessage)querySaver;
                    String cmd = redoable.getCommand();
                    Prepare prepare = this.context.getPrepareCache().get(cmd, redoable.prep());
                    if (prepare == null) {
                        PreparePacket preparePacket = new PreparePacket(cmd);
                        this.sendQuery(preparePacket);
                        prepare = (PrepareResultPacket)this.readPacket(preparePacket);
                        logger.info("replayed command after failover: " + preparePacket.description());
                    }
                    responseNo = querySaver.reEncode(this.writer, this.context, prepare);
                } else {
                    responseNo = querySaver.reEncode(this.writer, this.context, null);
                }
                logger.info("replayed command after failover: " + querySaver.description());
                for (int j = 0; j < responseNo; ++j) {
                    this.readResponse(querySaver);
                }
            }
        }
        catch (IOException e) {
            throw this.context.getExceptionFactory().create("Socket error during transaction replay", "08000", e);
        }
    }
}

