/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mariadb.client.socket.impl;

import com.itsschatten.libs.drivers.mariadb.Configuration;
import com.itsschatten.libs.drivers.mariadb.HostAddress;
import com.itsschatten.libs.drivers.mariadb.client.ReadableByteBuf;
import com.itsschatten.libs.drivers.mariadb.client.impl.StandardReadableByteBuf;
import com.itsschatten.libs.drivers.mariadb.client.socket.Reader;
import com.itsschatten.libs.drivers.mariadb.client.util.MutableByte;
import com.itsschatten.libs.drivers.mariadb.util.log.Logger;
import com.itsschatten.libs.drivers.mariadb.util.log.LoggerHelper;
import com.itsschatten.libs.drivers.mariadb.util.log.Loggers;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class PacketReader
implements Reader {
    private static final int REUSABLE_BUFFER_LENGTH = 1024;
    private static final int MAX_PACKET_SIZE = 0xFFFFFF;
    private static final Logger logger = Loggers.getLogger(PacketReader.class);
    private final byte[] header = new byte[4];
    private final byte[] reusableArray = new byte[1024];
    private final InputStream inputStream;
    private final int maxQuerySizeToLog;
    private final MutableByte sequence;
    private final StandardReadableByteBuf readBuf = new StandardReadableByteBuf(null, 0);
    private String serverThreadLog = "";

    public PacketReader(InputStream in, Configuration conf, MutableByte sequence) {
        this.inputStream = in;
        this.maxQuerySizeToLog = conf.maxQuerySizeToLog();
        this.sequence = sequence;
    }

    @Override
    public ReadableByteBuf readableBufFromArray(byte[] buf) {
        this.readBuf.buf(buf, buf.length, 0);
        return this.readBuf;
    }

    @Override
    public ReadableByteBuf readReusablePacket() throws IOException {
        return this.readReusablePacket(logger.isTraceEnabled());
    }

    @Override
    public ReadableByteBuf readReusablePacket(boolean traceEnable) throws IOException {
        int count;
        int count2;
        int remaining = 4;
        int off = 0;
        do {
            if ((count2 = this.inputStream.read(this.header, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + off + " bytes from 4 (socket was closed by server)");
            }
            off += count2;
        } while ((remaining -= count2) > 0);
        int lastPacketLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
        this.sequence.set(this.header[3]);
        byte[] rawBytes = lastPacketLength < 1024 ? this.reusableArray : new byte[lastPacketLength];
        remaining = lastPacketLength;
        off = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + (lastPacketLength - remaining) + " bytes from " + lastPacketLength + " (socket was closed by server)");
            }
            off += count;
        } while ((remaining -= count) > 0);
        if (traceEnable) {
            logger.trace("read: {}\n{}", this.serverThreadLog, LoggerHelper.hex(this.header, rawBytes, 0, lastPacketLength, this.maxQuerySizeToLog));
        }
        this.readBuf.buf(rawBytes, lastPacketLength, 0);
        return this.readBuf;
    }

    @Override
    public byte[] readPacket(boolean traceEnable) throws IOException {
        int count;
        int count2;
        int remaining = 4;
        int off = 0;
        do {
            if ((count2 = this.inputStream.read(this.header, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + off + " bytes from 4 (socket was closed by server)");
            }
            off += count2;
        } while ((remaining -= count2) > 0);
        int lastPacketLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
        byte[] rawBytes = new byte[lastPacketLength];
        remaining = lastPacketLength;
        off = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + (lastPacketLength - remaining) + " bytes from " + lastPacketLength + " (socket was closed by server)");
            }
            off += count;
        } while ((remaining -= count) > 0);
        if (traceEnable) {
            logger.trace("read: {}\n{}", this.serverThreadLog, LoggerHelper.hex(this.header, rawBytes, 0, lastPacketLength, this.maxQuerySizeToLog));
        }
        if (lastPacketLength == 0xFFFFFF) {
            int packetLength;
            do {
                int count3;
                int count4;
                remaining = 4;
                off = 0;
                do {
                    if ((count4 = this.inputStream.read(this.header, off, remaining)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + off + " bytes from 4");
                    }
                    off += count4;
                } while ((remaining -= count4) > 0);
                packetLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
                int currentbufLength = rawBytes.length;
                byte[] newRawBytes = new byte[currentbufLength + packetLength];
                System.arraycopy(rawBytes, 0, newRawBytes, 0, currentbufLength);
                rawBytes = newRawBytes;
                remaining = packetLength;
                off = currentbufLength;
                do {
                    if ((count3 = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + (packetLength - remaining) + " bytes from " + packetLength);
                    }
                    off += count3;
                } while ((remaining -= count3) > 0);
                if (traceEnable) {
                    logger.trace("read: {}\n{}", this.serverThreadLog, LoggerHelper.hex(this.header, rawBytes, currentbufLength, packetLength, this.maxQuerySizeToLog));
                }
                lastPacketLength += packetLength;
            } while (packetLength == 0xFFFFFF);
        }
        return rawBytes;
    }

    @Override
    public void skipPacket() throws IOException {
        int lastPacketLength;
        int count;
        if (logger.isTraceEnabled()) {
            this.readReusablePacket(logger.isTraceEnabled());
            return;
        }
        int remaining = 4;
        int off = 0;
        do {
            if ((count = this.inputStream.read(this.header, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + off + " bytes from 4 (socket was closed by server)");
            }
            off += count;
        } while ((remaining -= count) > 0);
        remaining = lastPacketLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
        while ((remaining -= (int)this.inputStream.skip(remaining)) > 0) {
        }
        if (lastPacketLength == 0xFFFFFF) {
            int packetLength;
            do {
                int count2;
                remaining = 4;
                off = 0;
                do {
                    if ((count2 = this.inputStream.read(this.header, off, remaining)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + off + " bytes from 4");
                    }
                    off += count2;
                } while ((remaining -= count2) > 0);
                remaining = packetLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
                while ((remaining -= (int)this.inputStream.skip(remaining)) > 0) {
                }
                lastPacketLength += packetLength;
            } while (packetLength == 0xFFFFFF);
        }
    }

    @Override
    public MutableByte getSequence() {
        return this.sequence;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void setServerThreadId(Long serverThreadId, HostAddress hostAddress) {
        Boolean isMaster = hostAddress != null ? hostAddress.primary : null;
        this.serverThreadLog = "conn=" + (serverThreadId == null ? "-1" : serverThreadId) + (isMaster != null ? " (" + (isMaster != false ? "M" : "S") + ")" : "");
    }
}

