/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mariadb.message.server;

import com.itsschatten.libs.drivers.mariadb.ServerPreparedStatement;
import com.itsschatten.libs.drivers.mariadb.client.Client;
import com.itsschatten.libs.drivers.mariadb.client.Context;
import com.itsschatten.libs.drivers.mariadb.client.ReadableByteBuf;
import com.itsschatten.libs.drivers.mariadb.client.socket.Reader;
import com.itsschatten.libs.drivers.mariadb.message.server.PrepareResultPacket;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class CachedPrepareResultPacket
extends PrepareResultPacket {
    private final AtomicBoolean closing = new AtomicBoolean();
    private final AtomicBoolean cached = new AtomicBoolean();
    private final List<ServerPreparedStatement> statements = new ArrayList<ServerPreparedStatement>();

    public CachedPrepareResultPacket(ReadableByteBuf buffer, Reader reader, Context context) throws IOException {
        super(buffer, reader, context);
    }

    @Override
    public void close(Client con) throws SQLException {
        if (!this.cached.get() && this.closing.compareAndSet(false, true)) {
            con.closePrepare(this);
        }
    }

    @Override
    public void decrementUse(Client con, ServerPreparedStatement preparedStatement) throws SQLException {
        this.statements.remove(preparedStatement);
        if (this.statements.size() == 0 && !this.cached.get()) {
            this.close(con);
        }
    }

    public void incrementUse(ServerPreparedStatement preparedStatement) {
        if (this.closing.get()) {
            return;
        }
        if (preparedStatement != null) {
            this.statements.add(preparedStatement);
        }
    }

    public void unCache(Client con) {
        this.cached.set(false);
        if (this.statements.size() <= 0) {
            try {
                this.close(con);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public boolean cache() {
        if (this.closing.get()) {
            return false;
        }
        return this.cached.compareAndSet(false, true);
    }

    @Override
    public int getStatementId() {
        return this.statementId;
    }

    public void reset() {
        this.statementId = -1;
        for (ServerPreparedStatement stmt : this.statements) {
            stmt.reset();
        }
    }
}

