/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mariadb.plugin;

import com.itsschatten.libs.drivers.mariadb.client.ColumnDecoder;
import com.itsschatten.libs.drivers.mariadb.client.Context;
import com.itsschatten.libs.drivers.mariadb.client.ReadableByteBuf;
import com.itsschatten.libs.drivers.mariadb.client.socket.Writer;
import com.itsschatten.libs.drivers.mariadb.client.util.MutableInt;
import java.io.IOException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Calendar;

public interface Codec<T> {
    public String className();

    public boolean canDecode(ColumnDecoder var1, Class<?> var2);

    public boolean canEncode(Object var1);

    public T decodeText(ReadableByteBuf var1, MutableInt var2, ColumnDecoder var3, Calendar var4) throws SQLDataException;

    public T decodeBinary(ReadableByteBuf var1, MutableInt var2, ColumnDecoder var3, Calendar var4) throws SQLDataException;

    public void encodeText(Writer var1, Context var2, Object var3, Calendar var4, Long var5) throws IOException, SQLException;

    public void encodeBinary(Writer var1, Object var2, Calendar var3, Long var4) throws IOException, SQLException;

    default public boolean canEncodeLongData() {
        return false;
    }

    default public void encodeLongData(Writer encoder, T value, Long length) throws IOException, SQLException {
        throw new SQLException("Data is not supposed to be send in COM_STMT_LONG_DATA");
    }

    default public byte[] encodeData(T value, Long length) throws IOException, SQLException {
        throw new SQLException("Data is not supposed to be send in COM_STMT_LONG_DATA");
    }

    public int getBinaryEncodeType();
}

