/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mariadb.plugin.codec;

import com.itsschatten.libs.drivers.mariadb.client.ColumnDecoder;
import com.itsschatten.libs.drivers.mariadb.client.Context;
import com.itsschatten.libs.drivers.mariadb.client.DataType;
import com.itsschatten.libs.drivers.mariadb.client.ReadableByteBuf;
import com.itsschatten.libs.drivers.mariadb.client.socket.Writer;
import com.itsschatten.libs.drivers.mariadb.client.util.MutableInt;
import com.itsschatten.libs.drivers.mariadb.plugin.Codec;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;

public class IntCodec
implements Codec<Integer> {
    public static final IntCodec INSTANCE = new IntCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.FLOAT, new DataType[]{DataType.DOUBLE, DataType.OLDDECIMAL, DataType.VARCHAR, DataType.DECIMAL, DataType.ENUM, DataType.VARSTRING, DataType.STRING, DataType.TINYINT, DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT, DataType.BIT, DataType.YEAR, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Integer.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Integer.TYPE || type.isAssignableFrom(Integer.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Integer;
    }

    @Override
    public Integer decodeText(ReadableByteBuf buffer, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeIntText(buffer, length);
    }

    @Override
    public Integer decodeBinary(ReadableByteBuf buffer, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeIntBinary(buffer, length);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeAscii(value.toString());
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeInt((Integer)value);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.INTEGER.get();
    }
}

