/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mariadb.plugin.credential.aws;

import com.itsschatten.libs.drivers.mariadb.Configuration;
import com.itsschatten.libs.drivers.mariadb.HostAddress;
import com.itsschatten.libs.drivers.mariadb.plugin.Credential;
import com.itsschatten.libs.drivers.mariadb.plugin.CredentialPlugin;
import com.itsschatten.libs.drivers.mariadb.plugin.credential.aws.AwsCredentialGenerator;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class AwsIamCredentialPlugin
implements CredentialPlugin {
    private static final int TOKEN_TTL = 10;
    private static final Map<KeyCache, IdentityExpire> cache = new ConcurrentHashMap<KeyCache, IdentityExpire>();
    private AwsCredentialGenerator generator;
    private KeyCache key;

    @Override
    public String type() {
        return "AWS-IAM";
    }

    @Override
    public boolean mustUseSsl() {
        return true;
    }

    @Override
    public CredentialPlugin initialize(Configuration conf, String userName, HostAddress hostAddress) throws SQLException {
        try {
            Class.forName("software.amazon.awssdk.auth.credentials.AwsBasicCredentials");
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException("Identity plugin 'AWS-IAM' is used without having AWS SDK in classpath. Please add 'software.amazon.awssdk:rds' to classpath");
        }
        this.generator = new AwsCredentialGenerator(conf.nonMappedOptions(), conf.user(), hostAddress);
        this.key = new KeyCache(conf, conf.user(), hostAddress);
        return this;
    }

    @Override
    public Credential get() {
        IdentityExpire val = cache.get(this.key);
        if (val != null && val.isValid()) {
            return val.getCredential();
        }
        Credential credential = this.generator.getToken();
        cache.put(this.key, new IdentityExpire(credential));
        return credential;
    }

    private static class KeyCache {
        private final Configuration conf;
        private final String userName;
        private final HostAddress hostAddress;

        public KeyCache(Configuration conf, String userName, HostAddress hostAddress) {
            this.conf = conf;
            this.userName = userName;
            this.hostAddress = hostAddress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyCache keyCache = (KeyCache)o;
            return this.conf.equals(keyCache.conf) && Objects.equals(this.userName, keyCache.userName) && this.hostAddress.equals(keyCache.hostAddress);
        }

        public int hashCode() {
            return Objects.hash(this.conf, this.userName, this.hostAddress);
        }
    }

    private static class IdentityExpire {
        private final LocalDateTime expiration;
        private final Credential credential;

        public IdentityExpire(Credential credential) {
            this.credential = credential;
            this.expiration = LocalDateTime.now().plusMinutes(10L);
        }

        public boolean isValid() {
            return this.expiration.isAfter(LocalDateTime.now());
        }

        public Credential getCredential() {
            return this.credential;
        }
    }
}

