/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mariadb.plugin.credential.system;

import com.itsschatten.libs.drivers.mariadb.Configuration;
import com.itsschatten.libs.drivers.mariadb.HostAddress;
import com.itsschatten.libs.drivers.mariadb.plugin.Credential;
import com.itsschatten.libs.drivers.mariadb.plugin.CredentialPlugin;

public class PropertiesCredentialPlugin
implements CredentialPlugin {
    private Configuration conf;
    private String userName;

    @Override
    public String type() {
        return "PROPERTY";
    }

    @Override
    public CredentialPlugin initialize(Configuration conf, String userName, HostAddress hostAddress) {
        this.conf = conf;
        this.userName = userName;
        return this;
    }

    @Override
    public Credential get() {
        String userKey = this.conf.nonMappedOptions().getProperty("userKey");
        String pwdKey = this.conf.nonMappedOptions().getProperty("pwdKey");
        String propUser = System.getProperty(userKey != null ? userKey : "mariadb.user");
        return new Credential(propUser == null ? this.userName : propUser, System.getProperty(pwdKey != null ? pwdKey : "mariadb.pwd"));
    }
}

