/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mariadb.type;

import com.itsschatten.libs.drivers.mariadb.type.Geometry;
import com.itsschatten.libs.drivers.mariadb.type.LineString;
import com.itsschatten.libs.drivers.mariadb.type.Point;
import java.util.Arrays;

public class MultiLineString
implements Geometry {
    private final LineString[] lines;

    public MultiLineString(LineString[] lines) {
        this.lines = lines;
    }

    public LineString[] getLines() {
        return this.lines;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MULTILINESTRING(");
        int indexLine = 0;
        for (LineString ls : this.lines) {
            if (indexLine++ > 0) {
                sb.append(",");
            }
            sb.append("(");
            int index = 0;
            for (Point pt : ls.getPoints()) {
                if (index++ > 0) {
                    sb.append(",");
                }
                sb.append(pt.getX()).append(" ").append(pt.getY());
            }
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MultiLineString)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return Arrays.hashCode(this.lines);
    }
}

