/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mariadb.util.log;

import com.itsschatten.libs.drivers.mariadb.util.log.ConsoleLogger;
import com.itsschatten.libs.drivers.mariadb.util.log.JdkLogger;
import com.itsschatten.libs.drivers.mariadb.util.log.Logger;
import com.itsschatten.libs.drivers.mariadb.util.log.NoLogger;
import com.itsschatten.libs.drivers.mariadb.util.log.Slf4JLogger;
import java.util.HashMap;

public final class Loggers {
    public static final String FALLBACK_PROPERTY = "mariadb.logging.fallback";
    public static final String CONSOLE_DEBUG_PROPERTY = "mariadb.logging.fallback.console.debug";
    public static final String TEST_ENABLE_SLF4J = "mariadb.logging.slf4j.enable";
    public static final String NO_LOGGER_PROPERTY = "mariadb.logging.disable";
    private static LoggerFactory LOGGER_FACTORY;

    public static Logger getLogger(String name) {
        return LOGGER_FACTORY.getLogger(name);
    }

    public static Logger getLogger(Class<?> cls) {
        return LOGGER_FACTORY.getLogger(cls.getName());
    }

    public static void init() {
        String name = LoggerFactory.class.getName();
        LoggerFactory loggerFactory = null;
        if (Boolean.parseBoolean(System.getProperty(NO_LOGGER_PROPERTY, "false"))) {
            loggerFactory = new NoLoggerFactory();
        } else {
            try {
                if (Boolean.parseBoolean(System.getProperty(TEST_ENABLE_SLF4J, "true"))) {
                    Class.forName("org.slf4j.LoggerFactory");
                    loggerFactory = new Slf4JLoggerFactory();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (loggerFactory == null) {
                loggerFactory = "JDK".equalsIgnoreCase(System.getProperty(FALLBACK_PROPERTY)) ? new JdkLoggerFactory() : new ConsoleLoggerFactory();
            }
            try {
                loggerFactory.getLogger(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        LOGGER_FACTORY = loggerFactory;
    }

    static {
        Loggers.init();
    }

    private static final class ConsoleLoggerFactory
    implements LoggerFactory {
        private static final HashMap<String, Logger> consoleLoggers = new HashMap();

        private ConsoleLoggerFactory() {
        }

        @Override
        public Logger getLogger(String name) {
            return consoleLoggers.computeIfAbsent(name, n -> new ConsoleLogger((String)n, System.getProperty(Loggers.CONSOLE_DEBUG_PROPERTY) != null));
        }
    }

    private static class JdkLoggerFactory
    implements LoggerFactory {
        private JdkLoggerFactory() {
        }

        @Override
        public Logger getLogger(String name) {
            return new JdkLogger(java.util.logging.Logger.getLogger(name));
        }
    }

    private static class Slf4JLoggerFactory
    implements LoggerFactory {
        private Slf4JLoggerFactory() {
        }

        @Override
        public Logger getLogger(String name) {
            return new Slf4JLogger(org.slf4j.LoggerFactory.getLogger((String)name));
        }
    }

    private static class NoLoggerFactory
    implements LoggerFactory {
        private NoLoggerFactory() {
        }

        @Override
        public Logger getLogger(String name) {
            return new NoLogger();
        }
    }

    private static interface LoggerFactory {
        public Logger getLogger(String var1);
    }
}

