/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mysql.cj;

import com.itsschatten.libs.drivers.mysql.cj.CancelQueryTask;
import com.itsschatten.libs.drivers.mysql.cj.Messages;
import com.itsschatten.libs.drivers.mysql.cj.NativeSession;
import com.itsschatten.libs.drivers.mysql.cj.Query;
import com.itsschatten.libs.drivers.mysql.cj.Session;
import com.itsschatten.libs.drivers.mysql.cj.TransactionEventHandler;
import com.itsschatten.libs.drivers.mysql.cj.conf.HostInfo;
import com.itsschatten.libs.drivers.mysql.cj.conf.PropertyKey;
import com.itsschatten.libs.drivers.mysql.cj.exceptions.OperationCancelledException;
import com.itsschatten.libs.drivers.mysql.cj.protocol.a.NativeMessageBuilder;
import com.itsschatten.libs.drivers.mysql.cj.telemetry.TelemetryAttribute;
import com.itsschatten.libs.drivers.mysql.cj.telemetry.TelemetryScope;
import com.itsschatten.libs.drivers.mysql.cj.telemetry.TelemetrySpan;
import com.itsschatten.libs.drivers.mysql.cj.telemetry.TelemetrySpanName;
import java.util.TimerTask;

public class CancelQueryTaskImpl
extends TimerTask
implements CancelQueryTask {
    Query queryToCancel;
    Throwable caughtWhileCancelling = null;
    boolean queryTimeoutKillsConnection = false;

    public CancelQueryTaskImpl(Query cancellee) {
        this.queryToCancel = cancellee;
        NativeSession session = (NativeSession)cancellee.getSession();
        this.queryTimeoutKillsConnection = session.getPropertySet().getBooleanProperty(PropertyKey.queryTimeoutKillsConnection).getValue();
    }

    @Override
    public boolean cancel() {
        boolean res = super.cancel();
        this.queryToCancel = null;
        return res;
    }

    @Override
    public void run() {
        Thread cancelThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block35: {
                    Query localQueryToCancel = CancelQueryTaskImpl.this.queryToCancel;
                    if (localQueryToCancel == null) {
                        return;
                    }
                    NativeSession session = (NativeSession)localQueryToCancel.getSession();
                    if (session == null) {
                        return;
                    }
                    try {
                        if (CancelQueryTaskImpl.this.queryTimeoutKillsConnection) {
                            localQueryToCancel.setCancelStatus(Query.CancelStatus.CANCELED_BY_TIMEOUT);
                            session.invokeCleanupListeners(new OperationCancelledException(Messages.getString("Statement.ConnectionKilledDueToTimeout")));
                            break block35;
                        }
                        Object object = localQueryToCancel.getCancelTimeoutMutex();
                        synchronized (object) {
                            long origConnId = session.getThreadId();
                            HostInfo hostInfo = session.getHostInfo();
                            String database = hostInfo.getDatabase();
                            String user = hostInfo.getUser();
                            String password = hostInfo.getPassword();
                            NativeSession newSession = null;
                            try {
                                newSession = new NativeSession(hostInfo, session.getPropertySet());
                                TelemetrySpan span = newSession.getTelemetryHandler().startSpan(TelemetrySpanName.CANCEL_QUERY, new Object[0]);
                                try (TelemetryScope scope = span.makeCurrent();){
                                    span.setAttribute(TelemetryAttribute.DB_NAME, database);
                                    span.setAttribute(TelemetryAttribute.DB_OPERATION, "KILL");
                                    span.setAttribute(TelemetryAttribute.DB_STATEMENT, "KILL (...)");
                                    span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                                    span.setAttribute(TelemetryAttribute.DB_USER, user);
                                    span.setAttribute(TelemetryAttribute.THREAD_ID, Thread.currentThread().getId());
                                    span.setAttribute(TelemetryAttribute.THREAD_NAME, Thread.currentThread().getName());
                                    newSession.connect(hostInfo, user, password, database, 30000, new TransactionEventHandler(){

                                        @Override
                                        public void transactionCompleted() {
                                        }

                                        @Override
                                        public void transactionBegun() {
                                        }
                                    });
                                    newSession.getProtocol().sendCommand(new NativeMessageBuilder(newSession.getServerSession().supportsQueryAttributes()).buildComQuery(newSession.getSharedSendPacket(), (Session)newSession, "KILL QUERY " + origConnId), false, 0);
                                }
                                catch (Throwable t) {
                                    span.setError(t);
                                    throw t;
                                }
                                finally {
                                    span.end();
                                }
                            }
                            finally {
                                try {
                                    newSession.forceClose();
                                }
                                catch (Throwable throwable) {}
                            }
                            localQueryToCancel.setCancelStatus(Query.CancelStatus.CANCELED_BY_TIMEOUT);
                        }
                    }
                    catch (Throwable t) {
                        CancelQueryTaskImpl.this.caughtWhileCancelling = t;
                    }
                    finally {
                        CancelQueryTaskImpl.this.setQueryToCancel(null);
                    }
                }
            }
        };
        cancelThread.start();
    }

    @Override
    public Throwable getCaughtWhileCancelling() {
        return this.caughtWhileCancelling;
    }

    @Override
    public void setCaughtWhileCancelling(Throwable caughtWhileCancelling) {
        this.caughtWhileCancelling = caughtWhileCancelling;
    }

    @Override
    public Query getQueryToCancel() {
        return this.queryToCancel;
    }

    @Override
    public void setQueryToCancel(Query queryToCancel) {
        this.queryToCancel = queryToCancel;
    }
}

