/*
 * Decompiled with CFR 0.152.
 */
package com.itsschatten.libs.drivers.mysql.cj.protocol.a;

import com.itsschatten.libs.drivers.mysql.cj.conf.PropertyKey;
import com.itsschatten.libs.drivers.mysql.cj.protocol.ColumnDefinition;
import com.itsschatten.libs.drivers.mysql.cj.protocol.ProtocolEntityFactory;
import com.itsschatten.libs.drivers.mysql.cj.protocol.Resultset;
import com.itsschatten.libs.drivers.mysql.cj.protocol.ResultsetRow;
import com.itsschatten.libs.drivers.mysql.cj.protocol.a.AbstractRowFactory;
import com.itsschatten.libs.drivers.mysql.cj.protocol.a.MysqlTextValueDecoder;
import com.itsschatten.libs.drivers.mysql.cj.protocol.a.NativeConstants;
import com.itsschatten.libs.drivers.mysql.cj.protocol.a.NativePacketPayload;
import com.itsschatten.libs.drivers.mysql.cj.protocol.a.NativeProtocol;
import com.itsschatten.libs.drivers.mysql.cj.protocol.a.result.ByteArrayRow;
import com.itsschatten.libs.drivers.mysql.cj.protocol.a.result.TextBufferRow;

public class TextRowFactory
extends AbstractRowFactory
implements ProtocolEntityFactory<ResultsetRow, NativePacketPayload> {
    public TextRowFactory(NativeProtocol protocol, ColumnDefinition colDefinition, Resultset.Concurrency resultSetConcurrency, boolean canReuseRowPacketForBufferRow) {
        this.columnDefinition = colDefinition;
        this.resultSetConcurrency = resultSetConcurrency;
        this.canReuseRowPacketForBufferRow = canReuseRowPacketForBufferRow;
        this.useBufferRowSizeThreshold = protocol.getPropertySet().getMemorySizeProperty(PropertyKey.largeRowSizeThreshold);
        this.exceptionInterceptor = protocol.getExceptionInterceptor();
        this.valueDecoder = new MysqlTextValueDecoder();
    }

    @Override
    public ResultsetRow createFromMessage(NativePacketPayload rowPacket) {
        boolean useBufferRow;
        boolean bl = useBufferRow = this.canReuseRowPacketForBufferRow || this.columnDefinition.hasLargeFields() || rowPacket.getPayloadLength() >= (Integer)this.useBufferRowSizeThreshold.getValue();
        if (this.resultSetConcurrency == Resultset.Concurrency.UPDATABLE || !useBufferRow) {
            byte[][] rowBytes = new byte[this.columnDefinition.getFields().length][];
            for (int i = 0; i < this.columnDefinition.getFields().length; ++i) {
                rowBytes[i] = rowPacket.readBytes(NativeConstants.StringSelfDataType.STRING_LENENC);
            }
            return new ByteArrayRow(rowBytes, this.exceptionInterceptor);
        }
        return new TextBufferRow(rowPacket, this.columnDefinition, this.exceptionInterceptor, this.valueDecoder);
    }

    @Override
    public boolean canReuseRowPacketForBufferRow() {
        return this.canReuseRowPacketForBufferRow;
    }
}

